/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertMobicents;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugins.alertMobicents.MobiKind;
import org.rhq.enterprise.server.util.LookupUtil;

public class MobicentsSender
extends AlertSender {
    private final Log log = LogFactory.getLog(MobicentsSender.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SenderResult send(Alert alert) {
        String baseUrl = this.preferences.getSimpleValue("mobicentsServerUrl", "http://localhost:8080/mobicents");
        String tel = this.alertParameters.getSimpleValue("targetAddress", null);
        if (tel == null) {
            this.log.warn((Object)"No number to call given, not sending");
            return SenderResult.getSimpleFailure((String)"No target address given");
        }
        String kindString = this.alertParameters.getSimpleValue("kind", "VOICE");
        MobiKind kind = MobiKind.valueOf(kindString);
        Integer alertId = alert.getId();
        StringBuilder b = new StringBuilder("alertText=");
        Resource res = alert.getAlertDefinition().getResource();
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        switch (kind) {
            case VOICE: {
                b.append("Alert on resource ");
                do {
                    b.append(res.getName());
                    res = res.getParentResource();
                    if (res == null) continue;
                    b.append(" with parent ");
                } while (res != null);
                b.append(". Cause is ");
                Locale currentLocale = Locale.getDefault();
                Locale.setDefault(Locale.ENGLISH);
                b.append(alertManager.prettyPrintAlertConditions(alert, false));
                Locale.setDefault(currentLocale);
                boolean willBeDisabled = alertManager.willDefinitionBeDisabled(alert);
                if (!willBeDisabled) break;
                b.append(" The alert definition will now be disabled. \n\n");
                break;
            }
            case SMS: {
                b.append("Alert: ");
                b.append(res.getName());
                b.append(",id=(").append(res.getId()).append(")");
                b.append("Brought by RHQ");
                break;
            }
            default: {
                this.log.warn((Object)"Unsupported Mobicents notification type for now");
            }
        }
        int code = 0;
        HttpURLConnection conn = null;
        try {
            tel = tel.trim();
            String telEnc = URLEncoder.encode(tel, "UTF-8");
            switch (kind) {
                case SMS: {
                    baseUrl = baseUrl + "sms";
                    break;
                }
                case VOICE: {
                    baseUrl = baseUrl + "call";
                    break;
                }
                default: {
                    baseUrl = baseUrl + "--not-supported-yet--";
                }
            }
            baseUrl = baseUrl + "?alertId=" + alertId;
            baseUrl = baseUrl + "&tel=";
            if (kind == MobiKind.VOICE && !tel.startsWith("sip:")) {
                baseUrl = baseUrl + "sip:";
            }
            baseUrl = baseUrl + telEnc;
            if (kind == MobiKind.VOICE && !tel.contains("@")) {
                String domain = this.preferences.getSimpleValue("defaultVoipDomain", "localhost");
                baseUrl = baseUrl + "@" + domain;
            }
            this.log.info((Object)("Mobicents alert [" + (Object)((Object)kind) + "] to baseUrl [" + baseUrl + "] with message:\n" + b.toString()));
            URL url = new URL(baseUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            OutputStream out = conn.getOutputStream();
            out.write(b.toString().getBytes());
            out.flush();
            conn.connect();
            code = conn.getResponseCode();
        }
        catch (Exception e) {
            this.log.warn((Object)("Notification via VoIP failed: " + e));
            SenderResult senderResult = SenderResult.getSimpleFailure((String)("Sending failed " + e.getMessage()));
            return senderResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        if (code != 200) {
            this.log.info((Object)("Notification via Mobicents returned code " + code));
            return SenderResult.getSimpleFailure((String)("Notification via Mobicents returned code " + code));
        }
        return SenderResult.getSimpleSuccess((String)("Mobicents alert [" + (Object)((Object)kind) + "] to baseUrl [" + baseUrl + "]"));
    }
}

