/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertRoles;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.ResultState;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.util.LookupUtil;

public class RolesSender
extends AlertSender {
    private final Log log = LogFactory.getLog(RolesSender.class);

    public SenderResult send(Alert alert) {
        SenderResult noRecipients = new SenderResult(ResultState.FAILURE, "No recipient roles defined");
        PropertySimple rolesIdProp = this.alertParameters.getSimple("roleId");
        if (rolesIdProp == null) {
            return noRecipients;
        }
        String rolesIds = rolesIdProp.getStringValue();
        if (rolesIds == null) {
            return noRecipients;
        }
        String[] roles = rolesIds.split(",");
        if (roles.length == 0) {
            return noRecipients;
        }
        ArrayList<String> emails = new ArrayList<String>();
        RoleManagerLocal roleManager = LookupUtil.getRoleManager();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        for (String r : roles) {
            Role role = roleManager.getRole(overlord, Integer.parseInt(r));
            Set subjects = role.getSubjects();
            for (Subject subject : subjects) {
                String email = subject.getEmailAddress();
                if (email != null) {
                    emails.add(email);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Subject " + subject.getId() + " has no email associated "));
            }
        }
        return new SenderResult(ResultState.DEFERRED_EMAIL, "Sending to roles " + rolesIds, emails);
    }
}

