/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.bundle.ant.InvalidBuildFileException;
import org.rhq.bundle.ant.task.BundleTask;
import org.rhq.bundle.ant.task.DeployTask;
import org.rhq.bundle.ant.task.InputPropertyTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntLauncher {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String ANTCONTRIB_ANT_TASKS = "net/sf/antcontrib/antcontrib.properties";
    private static final String LIQUIBASE_ANT_TASKS = "liquibasetasks.properties";
    private static final String REFID_CONTEXT = "ant.parsing.context";
    private static final String BUNDLE_TASK_NAME = "rhq:bundle";
    private static final String INPUT_PROPERTY_TASK_NAME = "rhq:input-property";
    private static final String DEPLOY_TASK_NAME = "rhq:deploy";

    public BundleAntProject executeBundleDeployFile(File buildFile, String targetName, Properties buildProperties, List<BuildListener> buildListeners) throws InvalidBuildFileException {
        this.parseBundleDeployFile(buildFile);
        BundleAntProject project = new BundleAntProject();
        ClassLoader classLoader = this.getClass().getClassLoader();
        project.setCoreLoader(classLoader);
        project.init();
        project.setBaseDir(buildFile.getParentFile());
        try {
            if (buildProperties != null) {
                for (Map.Entry<Object, Object> property : buildProperties.entrySet()) {
                    project.setUserProperty(property.getKey().toString(), property.getValue().toString().replace("\\", "\\\\"));
                }
            }
            project.setUserProperty("ant.file", buildFile.getAbsolutePath());
            project.setUserProperty("ant.file.type", "file");
            ProjectHelper.configureProject((Project)project, (File)buildFile);
            if (buildListeners != null) {
                for (BuildListener buildListener : buildListeners) {
                    project.addBuildListener(buildListener);
                }
            }
            this.addTaskDefsForBundledTasks(project);
            project.executeTarget("");
            project.executeTarget(targetName == null ? project.getDefaultTarget() : targetName);
            return project;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute bundle deploy file [" + buildFile.getAbsolutePath() + "]. Cause: " + e, e);
        }
    }

    public BundleAntProject parseBundleDeployFile(File buildFile) throws InvalidBuildFileException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        BundleAntProject project = new BundleAntProject();
        project.setCoreLoader(classLoader);
        project.init();
        project.setBaseDir(buildFile.getParentFile());
        AllOrNothingTarget allOrNothingTarget = new AllOrNothingTarget(true);
        allOrNothingTarget.setName("");
        allOrNothingTarget.setProject(project);
        AntXMLContext context = new AntXMLContext((Project)project);
        context.setImplicitTarget((Target)allOrNothingTarget);
        context.getTargets().clear();
        context.getTargets().addElement(context.getImplicitTarget());
        project.addReference(REFID_CONTEXT, context);
        project.addReference("ant.targets", context.getTargets());
        ProjectHelper2 helper = new ProjectHelper2();
        try {
            helper.parse((Project)project, (Object)buildFile);
        }
        catch (BuildException e) {
            throw new InvalidBuildFileException("Failed to parse bundle Ant build file.", e);
        }
        this.validateAndPreprocess(project);
        this.log.debug((Object)"==================== PARSED BUNDLE ANT BUILD FILE ====================");
        this.log.debug((Object)(" Bundle Name: " + project.getBundleName()));
        this.log.debug((Object)(" Bundle Version: " + project.getBundleVersion()));
        this.log.debug((Object)(" Bundle Description: " + project.getBundleDescription()));
        this.log.debug((Object)(" Deployment Config Def: " + project.getConfigurationDefinition().getPropertyDefinitions().values()));
        this.log.debug((Object)"======================================================================");
        return project;
    }

    private void addTaskDefsForBundledTasks(BundleAntProject project) throws IOException, ClassNotFoundException {
        Properties taskDefs = this.buildTaskDefProperties(project.getCoreLoader());
        for (Map.Entry<Object, Object> taskDef : taskDefs.entrySet()) {
            project.addTaskDefinition(taskDef.getKey().toString(), Class.forName(taskDef.getValue().toString(), true, project.getCoreLoader()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties buildTaskDefProperties(ClassLoader classLoader) throws IOException {
        HashSet<String> customTaskDefs = new HashSet<String>(1);
        customTaskDefs.add(ANTCONTRIB_ANT_TASKS);
        customTaskDefs.add(LIQUIBASE_ANT_TASKS);
        Properties taskDefProps = new Properties();
        for (String customTaskDef : customTaskDefs) {
            InputStream taskDefsStream = classLoader.getResourceAsStream(customTaskDef);
            try {
                taskDefProps.load(taskDefsStream);
            }
            finally {
                taskDefsStream.close();
            }
        }
        return taskDefProps;
    }

    private void validateAndPreprocess(BundleAntProject project) throws InvalidBuildFileException {
        AntXMLContext antParsingContext = (AntXMLContext)project.getReference(REFID_CONTEXT);
        Vector targets = antParsingContext.getTargets();
        int bundleTaskCount = 0;
        Task unconfiguredBundleTask = null;
        for (Object targetObj : targets) {
            Task[] tasks;
            Target target = (Target)targetObj;
            for (Task task : tasks = target.getTasks()) {
                if (task.getTaskName().equals(BUNDLE_TASK_NAME)) {
                    this.abortIfTaskWithinTarget(target, task);
                    ++bundleTaskCount;
                    unconfiguredBundleTask = task;
                    continue;
                }
                if (task.getTaskName().equals(INPUT_PROPERTY_TASK_NAME)) {
                    this.abortIfTaskWithinTarget(target, task);
                    InputPropertyTask inputPropertyTask = (InputPropertyTask)AntLauncher.preconfigureTask(task);
                    continue;
                }
                if (!task.getTaskName().equals(DEPLOY_TASK_NAME)) continue;
                DeployTask deployTask = (DeployTask)AntLauncher.preconfigureTask(task);
                Map<File, File> files = deployTask.getFiles();
                for (File file : files.values()) {
                    project.getBundleFileNames().add(file.getName());
                }
                Set<File> archives = deployTask.getArchives();
                for (File archive : archives) {
                    project.getBundleFileNames().add(archive.getName());
                }
            }
        }
        if (bundleTaskCount == 0) {
            throw new InvalidBuildFileException("rhq:bundle task not found - an RHQ bundle Ant build file must contain exactly one rhq:bundle task.");
        }
        if (bundleTaskCount > 1) {
            throw new InvalidBuildFileException("More than one rhq:bundle task found - an RHQ bundle Ant build file must contain exactly one rhq:bundle task.");
        }
        BundleTask bundleTask = (BundleTask)AntLauncher.preconfigureTask(unconfiguredBundleTask);
    }

    private void abortIfTaskWithinTarget(Target target, Task task) throws InvalidBuildFileException {
        if (!target.getName().equals("")) {
            throw new InvalidBuildFileException(task.getTaskName() + " task found within [" + target.getName() + "] target - it must be outside of any targets (at the top of the build file).");
        }
    }

    private static Task preconfigureTask(Task task) {
        if (task instanceof UnknownElement) {
            task.maybeConfigure();
            Task resolvedTask = ((UnknownElement)task).getTask();
            return resolvedTask != null ? resolvedTask : task;
        }
        return task;
    }

    class AllOrNothingTarget
    extends Target {
        public boolean doNothing = true;

        AllOrNothingTarget(boolean doNothing) {
            this.doNothing = doNothing;
        }

        public void execute() throws BuildException {
            if (!this.doNothing) {
                super.execute();
            }
        }
    }
}

