/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.ChangesFileHashcodeMap;
import org.rhq.core.util.updater.DeployDifferences;
import org.rhq.core.util.updater.DeploymentProperties;
import org.rhq.core.util.updater.DeploymentsMetadata;
import org.rhq.core.util.updater.ExtractorZipFileVisitor;
import org.rhq.core.util.updater.FileHashcodeMap;
import org.rhq.core.util.updater.InMemoryZipFileVisitor;
import org.rhq.core.util.updater.StreamCopyDigest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployer {
    private final Log log = LogFactory.getLog(Deployer.class);
    private final DeploymentProperties deploymentProps;
    private final Set<File> zipFiles;
    private final Map<File, File> rawFiles;
    private final File destDir;
    private final Pattern filesToRealizeRegex;
    private final TemplateEngine templateEngine;
    private final Pattern ignoreRegex;
    private final DeploymentsMetadata deploymentsMetadata;

    public Deployer(DeploymentProperties deploymentProps, Set<File> zipFiles, Map<File, File> rawFiles, File destDir, Pattern filesToRealizeRegex, TemplateEngine templateEngine, Pattern ignoreRegex) {
        if (deploymentProps == null) {
            throw new IllegalArgumentException("deploymentProps == null");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("destDir == null");
        }
        if (zipFiles == null) {
            zipFiles = new HashSet<File>();
        }
        if (rawFiles == null) {
            rawFiles = new HashMap<File, File>();
        }
        if (zipFiles.size() == 0 && rawFiles.size() == 0) {
            throw new IllegalArgumentException("zipFiles/rawFiles are empty - nothing to do");
        }
        this.deploymentProps = deploymentProps;
        this.zipFiles = zipFiles;
        this.rawFiles = rawFiles;
        this.destDir = destDir;
        this.ignoreRegex = ignoreRegex;
        if (filesToRealizeRegex == null || templateEngine == null) {
            this.filesToRealizeRegex = null;
            this.templateEngine = null;
        } else {
            this.filesToRealizeRegex = filesToRealizeRegex;
            this.templateEngine = templateEngine;
        }
        this.deploymentsMetadata = new DeploymentsMetadata(destDir);
    }

    public FileHashcodeMap deploy(DeployDifferences diff) throws Exception {
        FileHashcodeMap map = null;
        map = !this.deploymentsMetadata.isManaged() ? this.performInitialDeployment(diff, false) : this.performUpdateDeployment(diff, false);
        return map;
    }

    public FileHashcodeMap dryRun(DeployDifferences diff) throws Exception {
        FileHashcodeMap map = null;
        map = !this.deploymentsMetadata.isManaged() ? this.performInitialDeployment(diff, true) : this.performUpdateDeployment(diff, true);
        return map;
    }

    private FileHashcodeMap performInitialDeployment(DeployDifferences diff, boolean dryRun) throws Exception {
        FileHashcodeMap newFileHashcodeMap = this.extractZipAndRawFiles(new HashMap<String, String>(0), diff, dryRun);
        if (diff != null) {
            diff.addAddedFiles(newFileHashcodeMap.keySet());
        }
        this.debug("Initial deployment finished. dryRun=", dryRun);
        return newFileHashcodeMap;
    }

    private FileHashcodeMap performUpdateDeployment(DeployDifferences diff, boolean dryRun) throws Exception {
        this.debug("Analyzing original, current and new files as part of update deployment. dryRun=", dryRun);
        DeploymentProperties originalDeploymentProps = this.deploymentsMetadata.getCurrentDeploymentProperties();
        FileHashcodeMap original = this.deploymentsMetadata.getCurrentDeploymentFileHashcodes();
        ChangesFileHashcodeMap current = original.rescan(this.destDir, this.ignoreRegex);
        FileHashcodeMap newFiles = this.getNewDeploymentFileHashcodeMap();
        if (current.getUnknownContent() != null) {
            throw new Exception("Failed to properly rescan the current deployment: " + current.getUnknownContent());
        }
        if (diff != null) {
            diff.addIgnoredFiles(current.getIgnored());
            for (Map.Entry entry : current.entrySet()) {
                String currentPath = (String)entry.getKey();
                String currentHashcode = (String)entry.getValue();
                if (currentHashcode.equals("?DELETED_FILE_HASHCODE?")) {
                    if (!newFiles.containsKey(currentPath)) continue;
                    diff.addAddedFile(currentPath);
                    continue;
                }
                if (!newFiles.containsKey(currentPath)) {
                    diff.addDeletedFile(currentPath);
                    continue;
                }
                if (newFiles.get(currentPath).equals(currentHashcode) || newFiles.get(currentPath).equals(original.get(currentPath))) continue;
                diff.addChangedFile(currentPath);
            }
            for (Map.Entry entry : newFiles.entrySet()) {
                if (current.containsKey(entry.getKey())) continue;
                diff.addAddedFile((String)entry.getKey());
            }
        }
        HashSet<String> currentFilesToBackup = new HashSet<String>(current.getAdditions().keySet());
        HashMap<String, String> currentFilesToLeaveAlone = new HashMap<String, String>();
        for (Map.Entry<String, String> changed : current.getChanges().entrySet()) {
            String changedFilePath = changed.getKey();
            String newHashcode = newFiles.get(changedFilePath);
            if (newHashcode != null) {
                String changedFileHashcode = changed.getValue();
                String originalFileHashcode = original.get(changedFilePath);
                if (newHashcode.equals(originalFileHashcode)) {
                    currentFilesToLeaveAlone.put(changedFilePath, originalFileHashcode);
                    continue;
                }
                if (newHashcode.equals(changedFileHashcode)) continue;
                currentFilesToBackup.add(changedFilePath);
                continue;
            }
            currentFilesToBackup.add(changedFilePath);
        }
        original = null;
        HashSet newNotFoundByRescan = new HashSet(newFiles.keySet());
        newNotFoundByRescan.removeAll(current.keySet());
        for (String newFileNotScanned : newNotFoundByRescan) {
            File newFileNotScannedFile = new File(newFileNotScanned);
            if (!newFileNotScannedFile.isAbsolute() || !newFileNotScannedFile.exists()) continue;
            currentFilesToBackup.add(newFileNotScanned);
            if (diff == null) continue;
            diff.removeAddedFile(newFileNotScanned);
            diff.addChangedFile(newFileNotScanned);
        }
        newNotFoundByRescan = null;
        Set currentFilesToDelete = current.keySet();
        currentFilesToDelete.removeAll(newFiles.keySet());
        currentFilesToDelete.removeAll(current.getDeletions().keySet());
        current = null;
        if (!currentFilesToBackup.isEmpty()) {
            int deploymentId = originalDeploymentProps.getDeploymentId();
            this.debug("Backing up files as part of update deployment. dryRun=", dryRun);
            for (String fileToBackupPath : currentFilesToBackup) {
                this.backupFile(diff, deploymentId, fileToBackupPath, dryRun);
            }
        }
        if (!currentFilesToDelete.isEmpty()) {
            this.debug("Deleting obsolete files as part of update deployment. dryRun=", dryRun);
            for (String fileToDeletePath : currentFilesToDelete) {
                boolean deleted;
                File doomedFile = new File(fileToDeletePath);
                if (!doomedFile.isAbsolute()) {
                    doomedFile = new File(this.destDir, fileToDeletePath);
                }
                if (deleted = !dryRun ? doomedFile.delete() : true) {
                    this.debug("Deleted obsolete file [", doomedFile, "]. dryRun=", dryRun);
                    continue;
                }
                this.debug("Failed to delete obsolete file [", doomedFile, "]");
                if (diff == null) continue;
                diff.addError(fileToDeletePath, "File [" + doomedFile.getAbsolutePath() + "] did not delete");
            }
        }
        this.debug("Copying new files as part of update deployment. dryRun=", dryRun);
        FileHashcodeMap newFileHashCodeMap = this.extractZipAndRawFiles(currentFilesToLeaveAlone, diff, dryRun);
        this.debug("Update deployment finished. dryRun=", dryRun);
        return newFileHashCodeMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void backupFile(DeployDifferences diff, int deploymentId, String fileToBackupPath, boolean dryRun) throws Exception {
        File bakFile;
        File fileToBackup;
        boolean isWindows = File.separatorChar == '\\';
        StringBuilder fileToBackupPathNoDriveLetter = null;
        String driveLetter = null;
        if (isWindows) {
            fileToBackupPathNoDriveLetter = new StringBuilder(fileToBackupPath);
            driveLetter = FileUtil.stripDriveLetter(fileToBackupPathNoDriveLetter);
        }
        if ((fileToBackup = new File(fileToBackupPath)).isAbsolute()) {
            File backupDir = this.deploymentsMetadata.getDeploymentExternalBackupDirectory(deploymentId);
            if (isWindows && driveLetter != null) {
                backupDir = new File(backupDir, "_" + driveLetter.toUpperCase());
                bakFile = new File(backupDir, fileToBackupPathNoDriveLetter.toString());
            } else {
                bakFile = new File(backupDir, fileToBackupPath);
            }
        } else {
            File backupDir = this.deploymentsMetadata.getDeploymentBackupDirectory(deploymentId);
            if (isWindows && driveLetter != null) {
                StringBuilder destDirAbsPathBuilder = new StringBuilder(this.destDir.getAbsolutePath());
                String destDirDriveLetter = FileUtil.stripDriveLetter(destDirAbsPathBuilder);
                if (destDirDriveLetter != null && !driveLetter.equals(destDirDriveLetter)) throw new Exception("Cannot backup relative path [" + fileToBackupPath + "] whose drive letter is different than the destination directory [" + this.destDir.getAbsolutePath() + "]");
                bakFile = new File(backupDir, fileToBackupPath);
                fileToBackup = new File(this.destDir, fileToBackupPathNoDriveLetter.toString());
            } else {
                bakFile = new File(backupDir, fileToBackupPath);
                fileToBackup = new File(this.destDir, fileToBackupPath);
            }
        }
        if (!dryRun) {
            bakFile.getParentFile().mkdirs();
            FileUtil.copyFile(fileToBackup, bakFile);
        }
        this.debug("Backed up file [", fileToBackup, "] to [", bakFile, "]. dryRun=", dryRun);
        if (diff == null) return;
        diff.addBackedUpFile(fileToBackupPath, bakFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileHashcodeMap extractZipAndRawFiles(Map<String, String> currentFilesToLeaveAlone, DeployDifferences diff, boolean dryRun) throws Exception {
        FileHashcodeMap newFileHashCodeMap = new FileHashcodeMap();
        for (File zipFile : this.zipFiles) {
            this.debug("Extracting zip [", zipFile, "] entries. dryRun=", dryRun);
            ExtractorZipFileVisitor visitor = new ExtractorZipFileVisitor(this.destDir, this.filesToRealizeRegex, this.templateEngine, currentFilesToLeaveAlone.keySet(), diff, dryRun);
            ZipUtil.walkZipFile(zipFile, visitor);
            newFileHashCodeMap.putAll(visitor.getFileHashcodeMap());
        }
        StreamCopyDigest copyDigester = new StreamCopyDigest();
        for (Map.Entry<File, File> rawFile : this.rawFiles.entrySet()) {
            String hashcode;
            String newLocationPath;
            File newLocationFile;
            block22: {
                FileInputStream in;
                File currentLocationFile = rawFile.getKey();
                newLocationFile = rawFile.getValue();
                newLocationPath = rawFile.getValue().getPath();
                newLocationPath = newFileHashCodeMap.convertPath(newLocationPath);
                if (currentFilesToLeaveAlone != null && currentFilesToLeaveAlone.containsKey(newLocationPath)) continue;
                if (!newLocationFile.isAbsolute()) {
                    newLocationFile = new File(this.destDir, newLocationFile.getPath());
                }
                if (!dryRun) {
                    File newLocationParentDir = newLocationFile.getParentFile();
                    newLocationParentDir.mkdirs();
                    if (!newLocationParentDir.isDirectory()) {
                        throw new Exception("Failed to create new parent directory for raw file [" + newLocationFile + "]");
                    }
                }
                if (this.filesToRealizeRegex != null && this.filesToRealizeRegex.matcher(newLocationPath).matches()) {
                    this.debug("Realizing file [", currentLocationFile, "] to [", newLocationFile, "]. dryRun=", dryRun);
                    in = new FileInputStream(currentLocationFile);
                    byte[] rawFileContent = StreamUtil.slurp(in);
                    String content = this.templateEngine.replaceTokens(new String(rawFileContent));
                    if (diff != null) {
                        diff.addRealizedFile(newLocationPath, content);
                    }
                    byte[] bytes = content.getBytes();
                    if (!dryRun) {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newLocationFile));
                        try {
                            out.write(bytes);
                        }
                        finally {
                            out.close();
                        }
                    }
                    MessageDigestGenerator hashcodeGenerator = copyDigester.getMessageDigestGenerator();
                    hashcodeGenerator.add(bytes);
                    hashcode = hashcodeGenerator.getDigestString();
                } else {
                    this.debug("Copying raw file [", currentLocationFile, "] to [", newLocationFile, "]. dryRun=", dryRun);
                    in = new FileInputStream(currentLocationFile);
                    try {
                        if (!dryRun) {
                            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newLocationFile));
                            try {
                                hashcode = copyDigester.copyAndCalculateHashcode(in, out);
                                break block22;
                            }
                            finally {
                                out.close();
                            }
                        }
                        hashcode = MessageDigestGenerator.getDigestString(in);
                    }
                    finally {
                        in.close();
                    }
                }
            }
            if (rawFile.getValue().isAbsolute()) {
                newFileHashCodeMap.put(newLocationFile.getAbsolutePath(), hashcode);
                continue;
            }
            newFileHashCodeMap.put(newLocationPath, hashcode);
        }
        newFileHashCodeMap.putAll(currentFilesToLeaveAlone);
        if (!dryRun) {
            this.deploymentsMetadata.setCurrentDeployment(this.deploymentProps, newFileHashCodeMap);
        }
        return newFileHashCodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileHashcodeMap getNewDeploymentFileHashcodeMap() throws Exception {
        FileHashcodeMap fileHashcodeMap = new FileHashcodeMap();
        for (File zipFile : this.zipFiles) {
            this.debug("Extracting zip [", zipFile, "] in-memory to determine hashcodes for all entries");
            InMemoryZipFileVisitor visitor = new InMemoryZipFileVisitor(this.filesToRealizeRegex, this.templateEngine);
            ZipUtil.walkZipFile(zipFile, visitor);
            fileHashcodeMap.putAll(visitor.getFileHashcodeMap());
        }
        MessageDigestGenerator generator = new MessageDigestGenerator();
        for (Map.Entry<File, File> rawFile : this.rawFiles.entrySet()) {
            String hashcode;
            InputStream in;
            File currentLocationFile = rawFile.getKey();
            File newLocationFile = rawFile.getValue();
            String newLocationPath = rawFile.getValue().getPath();
            if (!newLocationFile.isAbsolute()) {
                newLocationFile = new File(this.destDir, newLocationFile.getPath());
            }
            if (this.filesToRealizeRegex != null && this.filesToRealizeRegex.matcher(newLocationPath).matches()) {
                this.debug("Realizing file [", currentLocationFile, "] in-memory to determine its hashcode");
                in = new FileInputStream(currentLocationFile);
                byte[] rawFileContent = StreamUtil.slurp(in);
                String content = this.templateEngine.replaceTokens(new String(rawFileContent));
                generator.add(content.getBytes());
                hashcode = generator.getDigestString();
            } else {
                this.debug("Streaming file [", currentLocationFile, "] in-memory to determine its hashcode");
                in = new BufferedInputStream(new FileInputStream(currentLocationFile));
                try {
                    hashcode = generator.calcDigestString(in);
                }
                finally {
                    ((BufferedInputStream)in).close();
                }
            }
            if (rawFile.getValue().isAbsolute()) {
                fileHashcodeMap.put(newLocationFile.getAbsolutePath(), hashcode);
                continue;
            }
            fileHashcodeMap.put(newLocationPath, hashcode);
        }
        return fileHashcodeMap;
    }

    private void debug(Object ... objs) {
        if (this.log.isDebugEnabled()) {
            StringBuilder str = new StringBuilder();
            String bundleName = this.deploymentProps.getBundleName();
            String bundleVersion = this.deploymentProps.getBundleVersion();
            int deploymentId = this.deploymentProps.getDeploymentId();
            str.append("Bundle [").append(bundleName).append(" v").append(bundleVersion).append(']');
            str.append("; Deployment [").append(deploymentId).append("]: ");
            for (Object o : objs) {
                str.append(o);
            }
            this.log.debug((Object)str.toString());
        }
    }
}

