/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rhq.core.util.MessageDigestGenerator;

public class StreamCopyDigest {
    private final MessageDigestGenerator generator;

    public StreamCopyDigest() {
        this.generator = new MessageDigestGenerator();
    }

    public StreamCopyDigest(MessageDigestGenerator generator) {
        this.generator = generator;
    }

    public MessageDigestGenerator getMessageDigestGenerator() {
        return this.generator;
    }

    public String copyAndCalculateHashcode(InputStream in, OutputStream out) {
        try {
            byte[] buffer = new byte[32768];
            BufferedInputStream bufferedStream = new BufferedInputStream(in, buffer.length);
            int bytesRead = bufferedStream.read(buffer);
            while (bytesRead != -1) {
                out.write(buffer, 0, bytesRead);
                this.generator.add(buffer, 0, bytesRead);
                bytesRead = bufferedStream.read(buffer);
            }
            out.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Stream data cannot be copied", ioe);
        }
        return this.generator.getDigestString();
    }
}

