/*
 * RHQ Management Platform
 * Copyright (C) 2005-2010 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation, and/or the GNU Lesser
 * General Public License, version 2.1, also as published by the Free
 * Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License and the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * and the GNU Lesser General Public License along with this program;
 * if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

package org.rhq.core.domain.resource.composite;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * Contains information about disambiguation of a resource name.
 * 
 * @author Lukas Krejci
 */
public class DisambiguationReport<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    
    private T original;
    private List<ResourceParentFlyweight> parents;
    private String resourceTypeName;
    private String resourceTypePluginName;

    public DisambiguationReport(T original, List<ResourceParentFlyweight> parents, String resourceTypeName, String resourceTypePluginName) {
        this.original = original;
        this.parents = Collections.unmodifiableList(parents);
        this.resourceTypeName = resourceTypeName;
        this.resourceTypePluginName = resourceTypePluginName;
    }

    public T getOriginal() {
        return original;
    }
    
    public List<ResourceParentFlyweight> getParents() {
        return parents;
    }

    public String getResourceTypeName() {
        return resourceTypeName;
    }

    public String getResourceTypePluginName() {
        return resourceTypePluginName;
    }
    
    public String toString() {
        return "DisambiguationReport(type=" + resourceTypeName + ", plugin=" + resourceTypePluginName + ", parents=" + parents + ", original=" + original + ")";
    }
}