/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.DropForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.database.sql.FindForeignKeyConstraintsStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.template.JdbcTemplate;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropAllForeignKeyConstraintsChange
extends AbstractChange {
    private String baseTableSchemaName;
    private String baseTableName;
    private List<DropForeignKeyConstraintChange> childDropChanges;

    public DropAllForeignKeyConstraintsChange() {
        super("dropAllForeignKeyConstraints", "Drop All Foreign Key Constraints");
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public void setBaseTableSchemaName(String baseTableSchemaName) {
        this.baseTableSchemaName = baseTableSchemaName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.baseTableName) == null) {
            throw new InvalidChangeDefinitionException("baseTableName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        if (this.childDropChanges == null) {
            this.generateChildren(database);
        }
        if (this.childDropChanges != null) {
            for (DropForeignKeyConstraintChange change : this.childDropChanges) {
                sqlStatements.addAll(Arrays.asList(change.generateStatements(database)));
            }
        }
        return sqlStatements.toArray(new SqlStatement[sqlStatements.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        return "Foreign keys on base table " + this.getBaseTableName() + " dropped";
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement(this.getTagName());
        if (this.getBaseTableSchemaName() != null) {
            node.setAttribute("baseTableSchemaName", this.getBaseTableSchemaName());
        }
        node.setAttribute("baseTableName", this.getBaseTableName());
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> databaseObjects = null;
        if (this.childDropChanges != null) {
            databaseObjects = new HashSet<DatabaseObject>();
            for (DropForeignKeyConstraintChange change : this.childDropChanges) {
                databaseObjects.addAll(change.getAffectedDatabaseObjects());
            }
        }
        return databaseObjects;
    }

    private void generateChildren(Database database) throws UnsupportedChangeException {
        this.childDropChanges = new ArrayList<DropForeignKeyConstraintChange>();
        JdbcTemplate jdbc = database.getJdbcTemplate();
        FindForeignKeyConstraintsStatement sql = new FindForeignKeyConstraintsStatement(this.getBaseTableSchemaName(), this.getBaseTableName());
        try {
            List<Map> results = jdbc.queryForList((SqlStatement)sql, new ArrayList<SqlVisitor>());
            if (results != null && results.size() > 0) {
                for (Map result : results) {
                    String baseTableName = (String)result.get("TABLE_NAME");
                    String constraintName = (String)result.get("CONSTRAINT_NAME");
                    if (this.getBaseTableName().equals(baseTableName)) {
                        DropForeignKeyConstraintChange dropForeignKeyConstraintChange = new DropForeignKeyConstraintChange();
                        dropForeignKeyConstraintChange.setBaseTableSchemaName(this.getBaseTableSchemaName());
                        dropForeignKeyConstraintChange.setBaseTableName(baseTableName);
                        dropForeignKeyConstraintChange.setConstraintName(constraintName);
                        this.childDropChanges.add(dropForeignKeyConstraintChange);
                        continue;
                    }
                    throw new IllegalStateException("Expected to return only foreign keys for base table name: " + this.getBaseTableName() + " and got results for table: " + baseTableName);
                }
            }
        }
        catch (JDBCException e) {
            throw new UnsupportedChangeException("Failed to find foreign keys for table: " + this.getBaseTableName(), e);
        }
    }
}

