/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.sql.RenameViewStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.View;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameViewChange
extends AbstractChange {
    private String schemaName;
    private String oldViewName;
    private String newViewName;

    public RenameViewChange() {
        super("renameView", "Rename View");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getOldViewName() {
        return this.oldViewName;
    }

    public void setOldViewName(String oldViewName) {
        this.oldViewName = oldViewName;
    }

    public String getNewViewName() {
        return this.newViewName;
    }

    public void setNewViewName(String newViewName) {
        this.newViewName = newViewName;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.oldViewName) == null) {
            throw new InvalidChangeDefinitionException("oldViewName is required", this);
        }
        if (StringUtils.trimToNull(this.newViewName) == null) {
            throw new InvalidChangeDefinitionException("newViewName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        return new SqlStatement[]{new RenameViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getOldViewName(), this.getNewViewName())};
    }

    @Override
    protected Change[] createInverses() {
        RenameViewChange inverse = new RenameViewChange();
        inverse.setOldViewName(this.getNewViewName());
        inverse.setNewViewName(this.getOldViewName());
        return new Change[]{inverse};
    }

    @Override
    public String getConfirmationMessage() {
        return "View " + this.oldViewName + " renamed to " + this.newViewName;
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element element = currentChangeLogFileDOM.createElement(this.getTagName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("oldViewName", this.getOldViewName());
        element.setAttribute("newViewName", this.getNewViewName());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        View oldView = new View();
        oldView.setName(this.oldViewName);
        View newView = new View();
        newView.setName(this.newViewName);
        return new HashSet<DatabaseObject>(Arrays.asList(oldView, newView));
    }
}

