/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import liquibase.database.AbstractDatabase;
import liquibase.database.DataType;
import liquibase.database.DatabaseConnection;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.PostgresDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "PostgreSQL";
    private Set<String> systemTablesAndViews = new HashSet<String>();
    private String defaultDatabaseSchemaName;
    private static final DataType BOOLEAN_TYPE = new DataType("BOOLEAN", false);
    private static final DataType CURRENCY_TYPE = new DataType("DECIMAL", true);
    private static final DataType UUID_TYPE = new DataType("CHAR(36)", false);
    private static final DataType CLOB_TYPE = new DataType("TEXT", true);
    private static final DataType BLOB_TYPE = new DataType("BYTEA", false);
    private static final DataType DATETIME_TYPE = new DataType("TIMESTAMP WITH TIME ZONE", false);
    private String[] reservedWords = new String[]{"ALL", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASYMMETRIC", "AUTHORIZATION", "BETWEEN", "BINARY", "BOTH", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "CONSTRAINT", "CORRESPONDING", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "EXCEPT", "FALSE", "FOR", "FOREIGN", "FREEZE", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "ILIKE", "IN", "INITIALLY", "INNER", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NEW", "NOT", "NOTNULL", "NULL", "OFF", "OFFSET", "OLD", "ON", "ONLY", "OPEN", "OR", "ORDER", "OUTER", "OVERLAPS", "PLACING", "PRIMARY", "REFERENCES", "RETURNING", "RIGHT", "SELECT", "SESSION_USER", "SIMILAR", "SOME", "SYMMETRIC", "TABLE", "THEN", "TO", "TRAILING", "TRUE", "UNION", "UNIQUE", "USER", "USING", "VERBOSE", "WHEN", "WHERE"};

    @Override
    public String getProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public String getTypeName() {
        return "postgresql";
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(conn));
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        return null;
    }

    @Override
    public DataType getBooleanType() {
        return BOOLEAN_TYPE;
    }

    @Override
    public DataType getCurrencyType() {
        return CURRENCY_TYPE;
    }

    @Override
    public DataType getUUIDType() {
        return UUID_TYPE;
    }

    @Override
    public DataType getClobType() {
        return CLOB_TYPE;
    }

    @Override
    public DataType getBlobType() {
        return BLOB_TYPE;
    }

    @Override
    public DataType getDateTimeType() {
        return DATETIME_TYPE;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "NOW()";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        block5: {
            if (this.defaultDatabaseSchemaName == null) {
                try {
                    List<String> searchPaths = this.getSearchPaths();
                    if (searchPaths == null || searchPaths.size() <= 0) break block5;
                    for (String searchPath : searchPaths) {
                        if (searchPath == null || searchPath.length() <= 0) continue;
                        this.defaultDatabaseSchemaName = searchPath;
                        if (this.defaultDatabaseSchemaName.equals("$user") && this.getConnectionUsername() != null) {
                            this.defaultDatabaseSchemaName = !this.schemaExists(this.getConnectionUsername()) ? null : this.getConnectionUsername();
                        }
                        if (this.defaultDatabaseSchemaName == null) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.log(Level.SEVERE, "Failed to get default catalog name from postgres", e);
                }
            }
        }
        return this.defaultDatabaseSchemaName;
    }

    @Override
    public String getDefaultCatalogName() throws JDBCException {
        return "public";
    }

    @Override
    public String getDatabaseChangeLogTableName() {
        return super.getDatabaseChangeLogTableName().toLowerCase();
    }

    @Override
    public String getDatabaseChangeLogLockTableName() {
        return super.getDatabaseChangeLogLockTableName().toLowerCase();
    }

    @Override
    public SqlStatement createFindSequencesSQL(String schema) throws JDBCException {
        return new RawSqlStatement("SELECT relname AS SEQUENCE_NAME FROM pg_class, pg_namespace WHERE relkind='S' AND pg_class.relnamespace = pg_namespace.oid AND nspname = '" + this.convertRequestedSchemaToSchema(schema) + "' " + "AND 'nextval(''" + (schema == null ? "" : schema + ".") + "'||relname||'''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null) " + "AND 'nextval(''" + (schema == null ? "" : schema + ".") + "\"'||relname||'\"''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null) " + "AND 'nextval('''||relname||'''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null)");
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        return super.isSystemTable(catalogName, schemaName, tableName) || "pg_catalog".equals(schemaName) || "pg_toast".equals(schemaName) || tableName.endsWith("_seq") || tableName.endsWith("_key") || tableName.endsWith("_pkey") || tableName.startsWith("idx_") || tableName.startsWith("pk_");
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String schemaName, String name) throws JDBCException {
        return new RawSqlStatement("select definition from pg_views where viewname='" + name + "' AND schemaname='" + this.convertRequestedSchemaToSchema(schemaName) + "'");
    }

    @Override
    public String getColumnType(String columnType, Boolean autoIncrement) {
        if (columnType.startsWith("java.sql.Types.VARCHAR")) {
            return columnType.replace("java.sql.Types.", "");
        }
        String type = super.getColumnType(columnType, autoIncrement);
        if (type.startsWith("TEXT(")) {
            return this.getClobType().getDataTypeName();
        }
        if (type.toLowerCase().startsWith("float8")) {
            return "FLOAT8";
        }
        if (type.toLowerCase().startsWith("float4")) {
            return "FLOAT4";
        }
        if (autoIncrement != null && autoIncrement.booleanValue()) {
            if ("integer".equals(type.toLowerCase())) {
                return "serial";
            }
            if ("bigint".equals(type.toLowerCase()) || "bigserial".equals(type.toLowerCase())) {
                return "bigserial";
            }
            return "serial";
        }
        return type;
    }

    @Override
    public String getAutoIncrementClause() {
        return "";
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object defaultValue, int dataType, int columnSize, int decimalDigits) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            defaultValue = ((String)defaultValue).replaceAll("'::[\\w\\s]+$", "'");
            if (dataType == 91 || dataType == 92 || dataType == 93) {
                defaultValue = ((String)defaultValue).replaceFirst("-\\d+$", "");
            }
        }
        return super.convertDatabaseValueToJavaObject(defaultValue, dataType, columnSize, decimalDigits);
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws JDBCException {
        if (requestedSchema == null) {
            return this.getDefaultCatalogName();
        }
        return StringUtils.trimToNull(requestedSchema).toLowerCase();
    }

    @Override
    public String convertRequestedSchemaToCatalog(String requestedSchema) throws JDBCException {
        return super.convertRequestedSchemaToCatalog(requestedSchema);
    }

    @Override
    public String escapeTableName(String schemaName, String tableName) {
        if (StringUtils.trimToNull(tableName) != null && (this.hasCaseProblems(tableName) || this.isReservedWord(tableName))) {
            return super.escapeTableName(schemaName, "\"" + tableName + "\"");
        }
        return super.escapeTableName(schemaName, tableName);
    }

    @Override
    public String escapeConstraintName(String constraintName) {
        if (constraintName == null) {
            return null;
        }
        if (this.hasCaseProblems(constraintName) || this.isReservedWord(constraintName)) {
            return "\"" + constraintName + "\"";
        }
        return super.escapeConstraintName(constraintName);
    }

    @Override
    public String escapeColumnName(String schemaName, String tableName, String columnName) {
        if (this.hasCaseProblems(columnName) || this.isReservedWord(columnName)) {
            return "\"" + columnName + "\"";
        }
        return columnName;
    }

    private boolean hasCaseProblems(String tableName) {
        return tableName.matches(".*[A-Z].*") && tableName.matches(".*[a-z].*");
    }

    private boolean isReservedWord(String tableName) {
        for (int i = 0; i != this.reservedWords.length; ++i) {
            if (!this.reservedWords[i].toLowerCase().equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    private List<String> getSearchPaths() {
        ArrayList<String> searchPaths = null;
        try {
            String searchPathResult;
            Statement stmt;
            ResultSet searchPathQry;
            DatabaseConnection con = this.getConnection();
            if (con != null && (searchPathQry = (stmt = con.createStatement(1004, 1007)).executeQuery("SHOW search_path")).next() && (searchPathResult = searchPathQry.getString(1)) != null) {
                String[] dirtySearchPaths = searchPathResult.split("\\,");
                searchPaths = new ArrayList<String>();
                for (String searchPath : dirtySearchPaths) {
                    if ((searchPath = searchPath.trim()).equals("\"$user\"")) {
                        searchPath = "$user";
                    }
                    searchPaths.add(searchPath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.SEVERE, "Failed to get default catalog name from postgres", e);
        }
        return searchPaths;
    }

    private boolean catalogExists(String catalogName) throws SQLException {
        if (catalogName != null) {
            return this.runExistsQuery("select count(*) from information_schema.schemata where catalog_name='" + catalogName + "'");
        }
        return false;
    }

    private boolean schemaExists(String schemaName) throws SQLException {
        if (schemaName != null) {
            return this.runExistsQuery("select count(*) from information_schema.schemata where schema_name='" + schemaName + "'");
        }
        return false;
    }

    private boolean runExistsQuery(String query) throws SQLException {
        Integer count;
        DatabaseConnection con = this.getConnection();
        Statement stmt = con.createStatement(1004, 1007);
        ResultSet existsQry = stmt.executeQuery(query);
        return existsQry.next() && (count = Integer.valueOf(existsQry.getInt(1))) != null && count > 0;
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new PostgresDatabaseSnapshot(this, statusListeners, schema);
    }

    @Override
    public String escapeSequenceName(String schemaName, String sequenceName) {
        if (StringUtils.trimToNull(sequenceName) != null && (this.hasCaseProblems(sequenceName) || this.isReservedWord(sequenceName))) {
            return super.escapeSequenceName(schemaName, "\"" + sequenceName + "\"");
        }
        return super.escapeSequenceName(schemaName, sequenceName);
    }

    @Override
    protected Object convertToCorrectJavaType(String value, int dataType, int columnSize, int decimalDigits) throws ParseException {
        Object returnValue = super.convertToCorrectJavaType(value, dataType, columnSize, decimalDigits);
        if (returnValue != null && returnValue instanceof String && ((String)returnValue).startsWith("NULL::")) {
            return null;
        }
        return returnValue;
    }

    @Override
    public String escapeColumnNameList(String columnNames) {
        StringBuffer sb = new StringBuffer();
        for (String columnName : columnNames.split(",")) {
            String name;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (this.hasCaseProblems(name = columnName.trim()) || this.isReservedWord(name)) {
                name = "\"" + name + "\"";
            }
            sb.append(name);
        }
        return sb.toString();
    }
}

