/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.Arrays;
import java.util.Iterator;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.MSSQLDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.util.StringUtils;

public class CreateIndexStatement
implements SqlStatement {
    private String tableSchemaName;
    private String indexName;
    private String tableName;
    private String[] columns;
    private String tablespace;
    private Boolean unique;

    public CreateIndexStatement(String indexName, String tableSchemaName, String tableName, Boolean isUnique, String ... columns) {
        this.indexName = indexName;
        this.tableSchemaName = tableSchemaName;
        this.tableName = tableName;
        this.columns = columns;
        this.unique = isUnique;
    }

    public String getTableSchemaName() {
        return this.tableSchemaName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public CreateIndexStatement setTablespace(String tablespace) {
        this.tablespace = tablespace;
        return this;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE ");
        if (this.unique != null && this.unique.booleanValue()) {
            buffer.append("UNIQUE ");
        }
        buffer.append("INDEX ");
        buffer.append(database.escapeIndexName(null, this.getIndexName())).append(" ON ");
        buffer.append(database.escapeTableName(this.getTableSchemaName(), this.getTableName())).append("(");
        Iterator<String> iterator = Arrays.asList(this.getColumns()).iterator();
        while (iterator.hasNext()) {
            String column = iterator.next();
            buffer.append(database.escapeColumnName(this.getTableSchemaName(), this.getTableName(), column));
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        if (StringUtils.trimToNull(this.getTablespace()) != null && database.supportsTablespaces()) {
            if (database instanceof MSSQLDatabase || database instanceof SybaseASADatabase) {
                buffer.append(" ON ").append(this.getTablespace());
            } else if (database instanceof DB2Database) {
                buffer.append(" IN ").append(this.getTablespace());
            } else {
                buffer.append(" TABLESPACE ").append(this.getTablespace());
            }
        }
        return buffer.toString();
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }
}

