/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import java.util.ArrayList;
import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.FailedPrecondition;
import liquibase.preconditions.Precondition;
import liquibase.preconditions.PreconditionLogic;

public class AndPrecondition
extends PreconditionLogic {
    public void check(Database database, DatabaseChangeLog changeLog) throws PreconditionFailedException, PreconditionErrorException {
        boolean allPassed = true;
        ArrayList<FailedPrecondition> failures = new ArrayList<FailedPrecondition>();
        for (Precondition precondition : this.getNestedPreconditions()) {
            try {
                precondition.check(database, changeLog);
            }
            catch (PreconditionFailedException e) {
                failures.addAll(e.getFailedPreconditions());
                allPassed = false;
                break;
            }
        }
        if (!allPassed) {
            throw new PreconditionFailedException(failures);
        }
    }

    public String getTagName() {
        return "and";
    }
}

