/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.type;

import org.apache.tools.ant.BuildException;
import org.rhq.bundle.ant.type.AbstractBundleType;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;

public class InputPropertyType
extends AbstractBundleType {
    private String name;
    private String description;
    private boolean required = true;
    private String defaultValue;
    private String type = PropertySimpleType.STRING.xmlName();

    public void init() throws BuildException {
        boolean parseOnly;
        this.validateAttributes();
        ConfigurationDefinition configDef = this.getProject().getConfigurationDefinition();
        PropertySimpleType propType = PropertySimpleType.fromXmlName((String)this.type);
        PropertyDefinitionSimple propDef = new PropertyDefinitionSimple(this.name, this.description, this.required, propType);
        configDef.put((PropertyDefinition)propDef);
        String value = this.getProject().getProperty(this.name);
        if (value == null) {
            value = this.defaultValue;
            this.getProject().setProperty(this.name, value);
        }
        if (!(parseOnly = this.getProject().isParseOnly())) {
            if (value == null && this.required) {
                throw new BuildException("No value was specified for required input property '" + this.name + "', and no default is defined for the property.");
            }
            this.validateValue(value, propType);
            String valueString = value != null ? "'" + value + "'" : "<null>";
            this.log("Initializing input property '" + this.name + "' with value " + valueString + "...");
        }
        Configuration config = this.getProject().getConfiguration();
        PropertySimple prop = new PropertySimple(this.name, (Object)value);
        config.put((Property)prop);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected void validateAttributes() throws BuildException {
        PropertySimpleType propType;
        if (this.name == null) {
            throw new BuildException("The 'name' attribute is required.");
        }
        if (this.name.length() == 0) {
            throw new BuildException("The 'name' attribute must have a non-empty value.");
        }
        try {
            propType = PropertySimpleType.fromXmlName((String)this.type);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException("Illegal value for 'type' attribute: " + this.type);
        }
        if (this.defaultValue == null) {
            if (!this.required) {
                this.log("No default value was specified for optional input property '" + this.name + "'.", 1);
            }
        } else {
            try {
                this.validateValue(this.defaultValue, propType);
            }
            catch (RuntimeException e) {
                throw new BuildException("Default value '" + this.defaultValue + "' is not valid according to 'type' attribute: " + this.type, (Throwable)e);
            }
        }
    }

    private void validateValue(String value, PropertySimpleType propType) {
        if (value != null) {
            try {
                switch (propType) {
                    case BOOLEAN: {
                        if (value.equals(Boolean.TRUE.toString()) || value.equals(Boolean.FALSE.toString())) break;
                        throw new RuntimeException("Illegal value for boolean property - value must be 'true' or 'false'." + value);
                    }
                    case DOUBLE: {
                        Double.valueOf(value);
                        break;
                    }
                    case FLOAT: {
                        Float.valueOf(value);
                        break;
                    }
                    case INTEGER: {
                        Integer.valueOf(value);
                        break;
                    }
                    case LONG: {
                        Long.valueOf(value);
                    }
                }
            }
            catch (RuntimeException e) {
                throw new BuildException("'" + value + "' is not a legal value for input property '" + this.name + "', which has type '" + this.type + "'.", (Throwable)e);
            }
        }
    }
}

