/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.SybaseDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class AddDefaultValueStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String columnName;
    private Object defaultValue;

    public AddDefaultValueStatement(String schemaName, String tableName, String columnName, Object defaultValue) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.defaultValue = defaultValue;
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof SQLiteDatabase);
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        if (database instanceof SybaseDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " REPLACE " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " DEFAULT " + database.convertJavaObjectToString(this.getDefaultValue());
        }
        if (database instanceof SybaseASADatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " MODIFY " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " DEFAULT " + database.convertJavaObjectToString(this.getDefaultValue());
        }
        if (database instanceof MSSQLDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ADD CONSTRAINT " + ((MSSQLDatabase)database).generateDefaultConstraintName(this.getTableName(), this.getColumnName()) + " DEFAULT " + database.convertJavaObjectToString(this.getDefaultValue()) + " FOR " + this.getColumnName();
        }
        if (database instanceof MySQLDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " SET DEFAULT " + database.convertJavaObjectToString(this.getDefaultValue());
        }
        if (database instanceof OracleDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " MODIFY " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " DEFAULT " + database.convertJavaObjectToString(this.getDefaultValue());
        }
        if (database instanceof DerbyDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN  " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " WITH DEFAULT " + database.convertJavaObjectToString(this.getDefaultValue());
        }
        if (database instanceof MaxDBDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " COLUMN  " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " ADD DEFAULT " + database.convertJavaObjectToString(this.getDefaultValue());
        }
        return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN  " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " SET DEFAULT " + database.convertJavaObjectToString(this.getDefaultValue());
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

