/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.type;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Target;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.bundle.ant.type.AbstractBundleType;
import org.rhq.bundle.ant.type.ArchiveType;
import org.rhq.bundle.ant.type.FileSet;
import org.rhq.bundle.ant.type.FileType;
import org.rhq.bundle.ant.type.IgnoreType;
import org.rhq.bundle.ant.type.SystemServiceType;
import org.rhq.bundle.ant.type.UrlArchiveType;
import org.rhq.bundle.ant.type.UrlFileType;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeployDifferences;
import org.rhq.core.util.updater.Deployer;
import org.rhq.core.util.updater.DeploymentData;
import org.rhq.core.util.updater.DeploymentProperties;

public class DeploymentUnitType
extends AbstractBundleType {
    private String name;
    private String manageRootDir = Boolean.TRUE.toString();
    private Map<File, File> files = new LinkedHashMap<File, File>();
    private Map<URL, File> urlFiles = new LinkedHashMap<URL, File>();
    private Set<File> rawFilesToReplace = new LinkedHashSet<File>();
    private Set<URL> rawUrlFilesToReplace = new LinkedHashSet<URL>();
    private Map<File, String> localFileNames = new LinkedHashMap<File, String>();
    private Set<File> archives = new LinkedHashSet<File>();
    private Set<URL> urlArchives = new LinkedHashSet<URL>();
    private Map<File, Pattern> archiveReplacePatterns = new HashMap<File, Pattern>();
    private Map<URL, Pattern> urlArchiveReplacePatterns = new HashMap<URL, Pattern>();
    private Map<File, Boolean> archivesExploded = new HashMap<File, Boolean>();
    private Map<URL, Boolean> urlArchivesExploded = new HashMap<URL, Boolean>();
    private Map<File, String> localArchiveNames = new LinkedHashMap<File, String>();
    private SystemServiceType systemService;
    private Pattern ignorePattern;
    private String preinstallTarget;
    private String postinstallTarget;

    public void init() throws BuildException {
        if (this.systemService != null) {
            this.systemService.init();
        }
    }

    public void install(boolean revert, boolean clean) throws BuildException {
        block31: {
            if (clean) {
                this.getProject().auditLog(BundleAntProject.AuditStatus.INFO, "Clean Requested", "A clean deployment has been requested. Files will be deleted!", "A clean deployment has been requested. Files will be deleted from the destination directory prior to the new deployment files getting written", null);
            }
            if (revert) {
                this.getProject().auditLog(BundleAntProject.AuditStatus.INFO, "Revert Requested", "The previous deployment will be reverted!", "The previous deployment will be reverted. An attempt to restore backed up files and the old deployment content will be made", null);
            }
            try {
                boolean dryRun = this.getProject().isDryRun();
                boolean willManageRootDir = Boolean.parseBoolean(this.manageRootDir);
                File deployDir = this.getProject().getDeployDir();
                TemplateEngine templateEngine = this.createTemplateEngine();
                int deploymentId = this.getProject().getDeploymentId();
                DeploymentProperties deploymentProps = new DeploymentProperties(deploymentId, this.getProject().getBundleName(), this.getProject().getBundleVersion(), this.getProject().getBundleDescription());
                deploymentProps.setManageRootDir(willManageRootDir);
                if (this.preinstallTarget != null) {
                    this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Pre-Install Started", "The pre install target will start", "The pre install target named [" + this.preinstallTarget + "] will start", null);
                    Target target = (Target)this.getProject().getTargets().get(this.preinstallTarget);
                    if (target == null) {
                        try {
                            this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "Pre-Install Failure", "The pre install target does not exist", "The pre install target specified in the recipe [" + this.preinstallTarget + "] does not exist.", null);
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        throw new BuildException("Specified preinstall target (" + this.preinstallTarget + ") does not exist.");
                    }
                    target.performTasks();
                    this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Pre-Install Finished", "The pre install target has finished", null, null);
                }
                boolean haveSomethingToDo = false;
                if (!this.files.isEmpty()) {
                    haveSomethingToDo = true;
                    this.log("Deploying files " + this.files + "...", 3);
                }
                if (!this.urlFiles.isEmpty()) {
                    haveSomethingToDo = true;
                    this.log("Deploying files from URL " + this.urlFiles + "...", 3);
                }
                if (!this.archives.isEmpty()) {
                    haveSomethingToDo = true;
                    this.log("Deploying archives " + this.archives + "...", 3);
                }
                if (!this.urlArchives.isEmpty()) {
                    haveSomethingToDo = true;
                    this.log("Deploying archives from URL " + this.urlArchives + "...", 3);
                }
                if (!haveSomethingToDo) {
                    throw new BuildException("You must specify at least one file to deploy via nested file, archive, url-file, url-archive types in your recipe");
                }
                if (willManageRootDir) {
                    this.log("Managing the root directory of this deployment unit - unrelated files found will be removed", 3);
                    if (!dryRun) {
                        this.getProject().auditLog(BundleAntProject.AuditStatus.INFO, "Managing Top Level Deployment Directory", "The top level deployment directory will be managed - files found there will be backed up and removed!", "The bundle recipe has requested that the top level deployment directory be fully managed by RHQ.This means any files currently located in the top level deployment directory will be removed and backed up", null);
                    }
                } else {
                    this.log("Not managing the root directory of this deployment unit - unrelated files will remain intact", 3);
                }
                HashSet<File> allArchives = new HashSet<File>(this.archives);
                HashMap<File, File> allFiles = new HashMap<File, File>(this.files);
                HashMap<File, Pattern> allArchiveReplacePatterns = new HashMap<File, Pattern>(this.archiveReplacePatterns);
                HashSet<File> allRawFilesToReplace = new HashSet<File>(this.rawFilesToReplace);
                HashMap<File, Boolean> allArchivesExploded = new HashMap<File, Boolean>(this.archivesExploded);
                this.downloadFilesFromUrlEndpoints(allArchives, allFiles, allArchiveReplacePatterns, allRawFilesToReplace, allArchivesExploded);
                try {
                    DeploymentData deploymentData = new DeploymentData(deploymentProps, allArchives, allFiles, this.getProject().getBaseDir(), deployDir, allArchiveReplacePatterns, allRawFilesToReplace, templateEngine, this.ignorePattern, willManageRootDir, allArchivesExploded);
                    Deployer deployer = new Deployer(deploymentData);
                    DeployDifferences diffs = this.getProject().getDeployDifferences();
                    if (!dryRun) {
                        this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Deployer Started", "The deployer has started its work", null, null);
                    }
                    if (revert) {
                        deployer.redeployAndRestoreBackupFiles(diffs, clean, dryRun);
                    } else {
                        deployer.deploy(diffs, clean, dryRun);
                    }
                    if (!dryRun) {
                        this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Deployer Finished", "The deployer has finished its work", null, diffs.toString());
                    }
                }
                catch (Throwable t) {
                    try {
                        this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "Deployer Failed", "The deployer encountered an error and could not finished", ThrowableUtil.getAllMessages((Throwable)t), ThrowableUtil.getStackAsString((Throwable)t));
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    throw new BuildException("Failed to deploy bundle [" + this.getProject().getBundleName() + "] version [" + this.getProject().getBundleVersion() + "]: " + t, t);
                }
                if (this.systemService != null) {
                    this.systemService.install();
                }
                if (this.postinstallTarget == null) break block31;
                this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Post-Install Started", "The post install target will start", "The post install target named [" + this.postinstallTarget + "] will start", null);
                Target target = (Target)this.getProject().getTargets().get(this.postinstallTarget);
                if (target == null) {
                    try {
                        this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "Post-Install Failure", "The post install target does not exist", "The post install target specified in the recipe [" + this.postinstallTarget + "] does not exist.", null);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    throw new BuildException("Specified postinstall target (" + this.postinstallTarget + ") does not exist.");
                }
                target.performTasks();
                this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "Post-Install Finished", "The post install target has finished", null, null);
            }
            catch (Throwable t) {
                try {
                    this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "Error Occurred", "The deployment could not complete successfully.", ThrowableUtil.getAllMessages((Throwable)t), ThrowableUtil.getStackAsString((Throwable)t));
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                if (t instanceof BuildException) {
                    throw (BuildException)t;
                }
                throw new BuildException(t);
            }
        }
    }

    private void downloadFilesFromUrlEndpoints(Set<File> allArchives, Map<File, File> allFiles, Map<File, Pattern> allArchiveReplacePatterns, Set<File> allRawFilesToReplace, Map<File, Boolean> allArchivesExploded) throws Exception {
        if (this.urlFiles.isEmpty() && this.urlArchives.isEmpty()) {
            return;
        }
        File downloadDir = this.getProject().getBaseDir();
        Set<File> downloadedFiles = this.getProject().getDownloadedFiles();
        try {
            File tmpFile;
            for (Map.Entry<URL, File> fileEntry : this.urlFiles.entrySet()) {
                URL url = fileEntry.getKey();
                File destFile = fileEntry.getValue();
                tmpFile = new File(downloadDir, destFile.getPath());
                this.download(url, tmpFile);
                downloadedFiles.add(tmpFile);
                allFiles.put(tmpFile, destFile);
                if (!this.rawUrlFilesToReplace.contains(url)) continue;
                allRawFilesToReplace.add(tmpFile);
            }
            for (URL url : this.urlArchives) {
                int lastSlash;
                String baseFileName = url.getPath();
                if (baseFileName.endsWith("/")) {
                    baseFileName = baseFileName.substring(0, baseFileName.length());
                }
                if ((lastSlash = baseFileName.lastIndexOf(47)) != -1) {
                    baseFileName = baseFileName.substring(lastSlash + 1);
                }
                if (baseFileName.length() == 0) {
                    baseFileName = url.getHost();
                }
                tmpFile = new File(downloadDir, baseFileName);
                this.download(url, tmpFile);
                downloadedFiles.add(tmpFile);
                allArchives.add(tmpFile);
                if (this.urlArchiveReplacePatterns.containsKey(url)) {
                    allArchiveReplacePatterns.put(tmpFile, this.urlArchiveReplacePatterns.get(url));
                }
                if (!this.urlArchivesExploded.containsKey(url)) continue;
                allArchivesExploded.put(tmpFile, this.urlArchivesExploded.get(url));
            }
            return;
        }
        catch (Exception e) {
            try {
                for (File doomed : downloadedFiles) {
                    doomed.delete();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw e;
        }
    }

    private void download(URL url, File tmpFile) throws Exception {
        long size;
        this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "File Download Started", "Downloading file from URL", "Downloading file from URL: " + url, null);
        try {
            InputStream in = url.openStream();
            tmpFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(tmpFile);
            size = StreamUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Exception e) {
            this.getProject().auditLog(BundleAntProject.AuditStatus.FAILURE, "File Download Failed", "Failed to download content from a remote server", "Failed to download file from: " + url, ThrowableUtil.getStackAsString((Throwable)e));
            throw e;
        }
        this.getProject().auditLog(BundleAntProject.AuditStatus.SUCCESS, "File Download Finished", "Successfully downloaded file from URL", "Downloaded file of size [" + size + "] bytes from URL: " + url, null);
    }

    public void start() throws BuildException {
        if (this.systemService != null) {
            this.systemService.start();
        }
    }

    public void stop() throws BuildException {
        if (this.systemService != null) {
            this.systemService.stop();
        }
    }

    public void upgrade(boolean revert, boolean clean) throws BuildException {
        this.install(revert, clean);
    }

    public void uninstall() throws BuildException {
        if (this.systemService != null) {
            this.systemService.uninstall();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getManageRootDir() {
        return this.manageRootDir;
    }

    public void setManageRootDir(String booleanString) {
        if (!Boolean.TRUE.toString().equalsIgnoreCase(booleanString) && !Boolean.FALSE.toString().equalsIgnoreCase(booleanString)) {
            throw new BuildException("manageRootDir attribute must be 'true' or 'false': " + booleanString);
        }
        this.manageRootDir = booleanString;
    }

    public Map<File, File> getFiles() {
        return this.files;
    }

    public Map<File, String> getLocalFileNames() {
        return this.localFileNames;
    }

    public Set<File> getArchives() {
        return this.archives;
    }

    public Map<File, String> getLocalArchiveNames() {
        return this.localArchiveNames;
    }

    public Map<File, Boolean> getArchivesExploded() {
        return this.archivesExploded;
    }

    public String getPreinstallTarget() {
        return this.preinstallTarget;
    }

    public void setPreinstallTarget(String preinstallTarget) {
        this.preinstallTarget = preinstallTarget;
    }

    public String getPostinstallTarget() {
        return this.postinstallTarget;
    }

    public void setPostinstallTarget(String postinstallTarget) {
        this.postinstallTarget = postinstallTarget;
    }

    public void addConfigured(SystemServiceType systemService) {
        if (this.systemService != null) {
            throw new IllegalStateException("A rhq:deployment-unit element can only have one rhq:system-service child element.");
        }
        this.systemService = systemService;
        this.systemService.validate();
        this.files.put(this.systemService.getScriptFile(), this.systemService.getScriptDestFile());
        this.localFileNames.put(this.systemService.getScriptFile(), this.systemService.getScriptFileName());
        if (this.systemService.getConfigFile() != null) {
            this.files.put(this.systemService.getConfigFile(), this.systemService.getConfigDestFile());
            this.localFileNames.put(this.systemService.getConfigFile(), this.systemService.getConfigFileName());
            this.rawFilesToReplace.add(this.systemService.getConfigFile());
        }
    }

    public void addConfigured(FileType file) {
        File destFile = file.getDestinationFile();
        if (destFile == null) {
            File destDir = file.getDestinationDir();
            destFile = new File(destDir, file.getSource().getName());
        }
        this.files.put(file.getSource(), destFile);
        this.localFileNames.put(file.getSource(), file.getName());
        if (file.isReplace()) {
            this.rawFilesToReplace.add(file.getSource());
        }
    }

    public void addConfigured(ArchiveType archive) {
        this.archives.add(archive.getSource());
        this.localArchiveNames.put(archive.getSource(), archive.getName());
        Pattern replacePattern = archive.getReplacePattern();
        if (replacePattern != null) {
            this.archiveReplacePatterns.put(archive.getSource(), replacePattern);
        }
        Boolean exploded = Boolean.valueOf(archive.getExploded());
        this.archivesExploded.put(archive.getSource(), exploded);
    }

    public void addConfigured(UrlFileType file) {
        File destFile = file.getDestinationFile();
        if (destFile == null) {
            File destDir = file.getDestinationDir();
            destFile = new File(destDir, file.getBaseName());
        }
        this.urlFiles.put(file.getSource(), destFile);
        if (file.isReplace()) {
            this.rawUrlFilesToReplace.add(file.getSource());
        }
    }

    public void addConfigured(UrlArchiveType archive) {
        this.urlArchives.add(archive.getSource());
        Pattern replacePattern = archive.getReplacePattern();
        if (replacePattern != null) {
            this.urlArchiveReplacePatterns.put(archive.getSource(), replacePattern);
        }
        Boolean exploded = Boolean.valueOf(archive.getExploded());
        this.urlArchivesExploded.put(archive.getSource(), exploded);
    }

    public void addConfigured(IgnoreType ignore) {
        List<FileSet> fileSets = ignore.getFileSets();
        this.ignorePattern = DeploymentUnitType.getPattern(fileSets);
    }

    private TemplateEngine createTemplateEngine() {
        TemplateEngine templateEngine = SystemInfoFactory.fetchTemplateEngine();
        Configuration config = this.getProject().getConfiguration();
        for (PropertySimple prop : config.getSimpleProperties().values()) {
            templateEngine.getTokens().put(prop.getName(), prop.getStringValue());
        }
        templateEngine.getTokens().put("rhq.deploy.dir", this.getProject().getProperty("rhq.deploy.dir"));
        return templateEngine;
    }
}

