/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.type;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.optional.unix.Symlink;
import org.rhq.bundle.ant.type.AbstractBundleType;

public class SystemServiceType
extends AbstractBundleType {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final File REDHAT_RELEASE_FILE = new File("/etc/redhat-release");
    private static final Set<Character> REDHAT_RUN_LEVELS = new HashSet<Character>();
    private static final File INIT_DIR;
    private static final File SYSCONFIG_DIR;
    private static final File DEFAULT_ROOT;
    private String name;
    private File scriptFile;
    private File configFile;
    private String scriptFileName;
    private String configFileName;
    private boolean overwriteScript;
    private boolean overwriteConfig;
    private boolean overwriteLinks = true;
    private File root = DEFAULT_ROOT;
    private String startLevels;
    private Byte startPriority;
    private Byte stopPriority;
    private Set<Character> startLevelChars;
    private Set<Character> stopLevelChars;
    private File scriptDestFile;
    private File configDestFile;

    public void validate() throws BuildException {
        this.validateAttributes();
        this.scriptDestFile = new File(this.getInitDir(), this.name);
        this.configDestFile = new File(this.getSysConfigDir(), this.name);
    }

    public void init() throws BuildException {
        if (!OS_NAME.equals("Linux") || !REDHAT_RELEASE_FILE.exists()) {
            throw new BuildException("The system-service element is only supported on Red Hat Linux systems.");
        }
        if (!this.scriptFile.exists() || this.scriptFile.isDirectory()) {
            throw new BuildException("The 'scriptFile' attribute must be set to the path of an existing regular file.");
        }
        if (this.configFile != null && !this.configFile.exists() || this.configFile.isDirectory()) {
            throw new BuildException("The 'configFile' attribute must be set to the path of an existing regular file.");
        }
    }

    public void install() throws BuildException {
        File initDir;
        if (this.configFile != null) {
            File sysconfigDir = this.getSysConfigDir();
            if (!sysconfigDir.exists()) {
                sysconfigDir.mkdirs();
            }
            if (!sysconfigDir.canWrite()) {
                throw new BuildException(sysconfigDir + " directory is not writeable.");
            }
            this.setPermissions(this.configDestFile, "644");
        }
        if (!(initDir = this.getInitDir()).exists()) {
            initDir.mkdirs();
        }
        if (!initDir.canWrite()) {
            throw new BuildException(initDir + " directory is not writeable.");
        }
        this.getProject().log("Installing service script " + this.scriptDestFile + "...");
        this.setPermissions(this.scriptDestFile, "755");
        this.createScriptSymlinks(this.scriptDestFile, this.startPriority, this.startLevelChars, 'S');
        this.createScriptSymlinks(this.scriptDestFile, this.stopPriority, this.stopLevelChars, 'K');
    }

    private File getInitDir() {
        return new File(this.root, INIT_DIR.getPath().substring(1));
    }

    public File getScriptDestFile() {
        return this.scriptDestFile;
    }

    private File getSysConfigDir() {
        return new File(this.root, SYSCONFIG_DIR.getPath().substring(1));
    }

    public File getConfigDestFile() {
        return this.configDestFile;
    }

    public void start() throws BuildException {
        File scriptFile = this.getScriptDestFile();
        Object[] commandLine = new String[]{scriptFile.getAbsolutePath(), "start"};
        try {
            this.executeCommand((String[])commandLine);
        }
        catch (IOException e) {
            throw new BuildException("Failed to start " + this.name + " system service via command [" + Arrays.toString(commandLine) + "].", (Throwable)e);
        }
    }

    public void stop() throws BuildException {
        File scriptFile = this.getScriptDestFile();
        Object[] commandLine = new String[]{scriptFile.getAbsolutePath(), "stop"};
        try {
            this.executeCommand((String[])commandLine);
        }
        catch (IOException e) {
            throw new BuildException("Failed to stop " + this.name + " system service via command [" + Arrays.toString(commandLine) + "].", (Throwable)e);
        }
    }

    public void uninstall() throws BuildException {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(String scriptFile) {
        File file = new File(scriptFile);
        if (file.isAbsolute()) {
            throw new BuildException("Path specified by 'scriptFile' attribute (" + scriptFile + ") is not relative - it must be a relative path, relative to the Ant basedir.");
        }
        this.scriptFileName = scriptFile;
        this.scriptFile = this.getProject().resolveFile(scriptFile);
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        File file = new File(configFile);
        if (file.isAbsolute()) {
            throw new BuildException("Path specified by 'configFile' attribute (" + configFile + ") is not relative - it must be a relative path, relative to the Ant basedir.");
        }
        this.configFileName = configFile;
        this.configFile = this.getProject().resolveFile(configFile);
    }

    public boolean isOverwriteScript() {
        return this.overwriteScript;
    }

    public void setOverwriteScript(boolean overwriteScript) {
        this.overwriteScript = overwriteScript;
    }

    public boolean isOverwriteConfig() {
        return this.overwriteConfig;
    }

    public void setOverwriteConfig(boolean overwriteConfig) {
        this.overwriteConfig = overwriteConfig;
    }

    public boolean isOverwriteLinks() {
        return this.overwriteLinks;
    }

    public void setOverwriteLinks(boolean overwriteLinks) {
        this.overwriteLinks = overwriteLinks;
    }

    public String getStartLevels() {
        return this.startLevels;
    }

    public void setStartLevels(String startLevels) {
        this.startLevels = startLevels;
    }

    public byte getStartPriority() {
        return this.startPriority;
    }

    public void setStartPriority(byte startPriority) {
        this.startPriority = startPriority;
    }

    public byte getStopPriority() {
        return this.stopPriority;
    }

    public void setStopPriority(byte stopPriority) {
        this.stopPriority = stopPriority;
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File root) {
        this.root = root;
    }

    protected void validateAttributes() throws BuildException {
        if (this.name == null) {
            throw new BuildException("The 'name' attribute is required.");
        }
        if (this.name.length() == 0) {
            throw new BuildException("The 'name' attribute must have a non-empty value.");
        }
        if (this.scriptFile == null) {
            throw new BuildException("The 'scriptFile' attribute is required.");
        }
        if (this.startLevels == null) {
            throw new BuildException("The 'startLevels' attribute is required.");
        }
        if (this.startLevels.length() == 0) {
            throw new BuildException("The 'startLevels' attribute must have a non-empty value.");
        }
        this.startLevelChars = SystemServiceType.parseLevels(this.startLevels);
        this.stopLevelChars = new TreeSet<Character>();
        for (char level : REDHAT_RUN_LEVELS) {
            if (this.startLevelChars.contains(Character.valueOf(level))) continue;
            this.stopLevelChars.add(Character.valueOf(level));
        }
        if (this.startPriority == null) {
            throw new BuildException("The 'startPriority' attribute is required.");
        }
        if (this.startPriority < 0 || this.startPriority > 99) {
            throw new BuildException("The 'startPriority' attribute must be >=0 and <= 99.");
        }
        if (this.stopPriority == null) {
            throw new BuildException("The 'stopPriority' attribute is required.");
        }
        if (this.stopPriority < 0 || this.stopPriority > 99) {
            throw new BuildException("The 'startPriority' attribute must be >=0 and <= 99.");
        }
        if (!this.root.exists()) {
            this.root.mkdirs();
            if (!this.root.exists()) {
                throw new BuildException("Failed to create root directory " + this.root + " as specified by 'root' attribute.");
            }
        }
        if (!this.root.isDirectory()) {
            throw new BuildException("The 'root' attribute must be set to the path of a directory.");
        }
        if (!this.root.equals(DEFAULT_ROOT)) {
            this.getProject().log("Using root " + this.root + ".");
        }
    }

    private static Set<Character> parseLevels(String levels) {
        String[] tokens;
        TreeSet<Character> levelChars = new TreeSet<Character>();
        for (String token : tokens = levels.split("[ ]*,[ ]*")) {
            Character level;
            if (token.equals("")) continue;
            try {
                if (token.length() != 1) {
                    throw new Exception();
                }
                level = Character.valueOf(token.charAt(0));
                if (!REDHAT_RUN_LEVELS.contains(level)) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new BuildException("Invalid run level: " + token + " - the 'startLevels' attribute must be a comma-separated list of run levels - the valid levels are " + REDHAT_RUN_LEVELS + ".");
            }
            if (levelChars.contains(level)) {
                throw new BuildException("The 'startLevels' attribute defines run level " + level + " more than once.");
            }
            levelChars.add(level);
        }
        return levelChars;
    }

    private void createScriptSymlinks(File scriptFile, byte priority, Set<Character> levels, char fileNamePrefix) {
        String priorityString = String.format("%02d", priority);
        for (char level : levels) {
            File rcDir = new File(this.root, "etc/rc" + level + ".d");
            if (!rcDir.exists()) {
                rcDir.mkdirs();
            }
            if (!rcDir.exists()) {
                throw new BuildException(rcDir + " does not exist.");
            }
            if (!rcDir.isDirectory()) {
                throw new BuildException(rcDir + " exists but is not a directory.");
            }
            if (!rcDir.isDirectory()) {
                throw new BuildException(rcDir + " directory is not writeable.");
            }
            File link = new File(rcDir, fileNamePrefix + priorityString + this.name);
            this.getProject().log("Creating symbolic link " + link + " referencing " + scriptFile + "...");
            this.createSymlink(scriptFile, link, this.overwriteLinks);
        }
    }

    private void copyFile(File sourceFile, File destFile, boolean overwrite) {
        Copy copyTask = new Copy();
        copyTask.setProject((Project)this.getProject());
        copyTask.init();
        copyTask.setFile(sourceFile);
        copyTask.setTofile(destFile);
        copyTask.setOverwrite(overwrite);
        copyTask.execute();
    }

    private void createSymlink(File targetFile, File linkFile, boolean overwrite) {
        Symlink symlinkTask = new Symlink();
        symlinkTask.setProject((Project)this.getProject());
        symlinkTask.init();
        symlinkTask.setResource(targetFile.getAbsolutePath());
        symlinkTask.setLink(linkFile.getAbsolutePath());
        symlinkTask.setOverwrite(overwrite);
        symlinkTask.execute();
    }

    private int executeCommand(String[] commandLine) throws IOException {
        Execute executeTask = new Execute();
        executeTask.setCommandline(commandLine);
        return executeTask.execute();
    }

    private void setPermissions(File file, String perms) {
        Chmod chmodTask = new Chmod();
        chmodTask.setProject((Project)this.getProject());
        chmodTask.init();
        chmodTask.setFile(file);
        chmodTask.setPerm(perms);
        chmodTask.execute();
    }

    static {
        for (char c = '0'; c <= '6'; c = (char)(c + '\u0001')) {
            REDHAT_RUN_LEVELS.add(Character.valueOf(c));
        }
        INIT_DIR = new File("/etc/init.d");
        SYSCONFIG_DIR = new File("/etc/sysconfig");
        DEFAULT_ROOT = new File("/");
    }
}

