/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.io.IOException;
import java.util.List;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.Swap;
import org.rhq.core.system.CpuInformation;
import org.rhq.core.system.FileSystemInfo;
import org.rhq.core.system.NetworkAdapterInfo;
import org.rhq.core.system.NetworkAdapterStats;
import org.rhq.core.system.NetworkStats;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.ServiceInfo;
import org.rhq.core.system.SystemInfoException;

public interface SystemInfo {
    public boolean isNative();

    public OperatingSystemType getOperatingSystemType();

    public String getOperatingSystemName();

    public String getOperatingSystemVersion();

    public String getSystemArchitecture();

    public String getHostname() throws SystemInfoException;

    public List<NetworkAdapterInfo> getAllNetworkAdapters() throws SystemInfoException;

    public List<ServiceInfo> getAllServices() throws SystemInfoException;

    public List<ProcessInfo> getAllProcesses();

    public List<ProcessInfo> getProcesses(String var1);

    public ProcessInfo getThisProcess();

    public ProcessExecutionResults executeProcess(ProcessExecution var1);

    public int getNumberOfCpus();

    public Mem getMemoryInfo();

    public Swap getSwapInfo();

    public String readLineFromConsole(boolean var1) throws IOException;

    public void writeLineToConsole(String var1) throws IOException;

    public CpuInformation getCpu(int var1);

    public List<FileSystemInfo> getFileSystems();

    public FileSystemInfo getFileSystem(String var1);

    public DirUsage getDirectoryUsage(String var1);

    public NetworkAdapterStats getNetworkAdapterStats(String var1);

    public NetworkStats getNetworkStats(String var1, int var2);

    public List<NetConnection> getNetworkConnections(String var1, int var2);
}

