/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.system.JavaSystemInfo;
import org.rhq.core.system.NativeSystemInfo;
import org.rhq.core.system.NetworkAdapterInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.WindowsNativeSystemInfo;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.exception.ThrowableUtil;

public class SystemInfoFactory {
    public static final String TOKEN_PREFIX = "rhq.system.";
    private static final Log LOG = LogFactory.getLog(SystemInfoFactory.class);
    private static final String NATIVE_LIBRARY_CLASS_NAME = "org.hyperic.sigar.Sigar";
    private static boolean nativeLibraryLoadable;
    private static Throwable nativeLibraryLoadThrowable;
    private static boolean disabled;
    private static boolean initialized;
    private static final ThreadFactory threadFactory;
    private static ExecutorService executor;
    private static SystemInfo javaSystemInfo;
    private static SystemInfo cachedSystemInfo;
    private static Map<NativeApi, AccessibleObject> nativeApis;

    public static synchronized String getNativeSystemInfoVersion() {
        String version = null;
        Throwable error = null;
        SystemInfoFactory.initialize();
        if (!SystemInfoFactory.isNativeSystemInfoDisabled() && SystemInfoFactory.isNativeSystemInfoAvailable()) {
            try {
                version = "Version=" + SystemInfoFactory.invokeApi(NativeApi.VERSION_STRING, new Object[0]) + " (" + SystemInfoFactory.invokeApi(NativeApi.BUILD_DATE, new Object[0]) + "); Native version=" + SystemInfoFactory.invokeApi(NativeApi.NATIVE_VERSION_STRING, new Object[0]) + " (" + SystemInfoFactory.invokeApi(NativeApi.NATIVE_BUILD_DATE, new Object[0]) + ")";
            }
            catch (Throwable t) {
                error = t;
            }
        }
        if (version == null) {
            version = "Native system not supported - Java version is " + System.getProperty("java.version");
            if (error != null) {
                version = version + " : " + error;
            }
        }
        return version;
    }

    public static synchronized void disableNativeSystemInfo() {
        if (!disabled) {
            cachedSystemInfo = null;
        }
        disabled = true;
    }

    public static synchronized void enableNativeSystemInfo() {
        if (disabled) {
            cachedSystemInfo = null;
        }
        disabled = false;
    }

    public static synchronized boolean isNativeSystemInfoDisabled() {
        return disabled;
    }

    public static boolean isNativeSystemInfoAvailable() {
        SystemInfoFactory.initialize();
        return nativeLibraryLoadable;
    }

    public static Throwable getNativeLibraryLoadThrowable() {
        return nativeLibraryLoadThrowable;
    }

    public static synchronized boolean isNativeSystemInfoInitialized() {
        return initialized;
    }

    public static synchronized SystemInfo createSystemInfo() {
        if (cachedSystemInfo == null) {
            SystemInfoFactory.initialize();
            SystemInfo nativePlatform = null;
            if (!SystemInfoFactory.isNativeSystemInfoDisabled() && SystemInfoFactory.isNativeSystemInfoAvailable()) {
                nativePlatform = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 ? new WindowsNativeSystemInfo() : new NativeSystemInfo();
            }
            if (nativePlatform == null) {
                nativePlatform = javaSystemInfo;
            }
            cachedSystemInfo = nativePlatform;
        }
        return cachedSystemInfo;
    }

    public static SystemInfo createJavaSystemInfo() {
        return javaSystemInfo;
    }

    public static synchronized void shutdown() {
        executor.shutdown();
        executor = Executors.newCachedThreadPool(threadFactory);
        javaSystemInfo = new JavaSystemInfo(executor);
        if (initialized) {
            initialized = false;
            cachedSystemInfo = null;
        }
    }

    private static synchronized void initialize() {
        if (!initialized && !SystemInfoFactory.isNativeSystemInfoDisabled()) {
            try {
                Class<?> clazz = Class.forName(NATIVE_LIBRARY_CLASS_NAME);
                nativeApis.put(NativeApi.load, clazz.getMethod(NativeApi.load.name(), new Class[0]));
                nativeApis.put(NativeApi.VERSION_STRING, clazz.getField(NativeApi.VERSION_STRING.name()));
                nativeApis.put(NativeApi.BUILD_DATE, clazz.getField(NativeApi.BUILD_DATE.name()));
                nativeApis.put(NativeApi.NATIVE_VERSION_STRING, clazz.getField(NativeApi.NATIVE_VERSION_STRING.name()));
                nativeApis.put(NativeApi.NATIVE_BUILD_DATE, clazz.getField(NativeApi.NATIVE_BUILD_DATE.name()));
                SystemInfoFactory.invokeApi(NativeApi.load, new Object[0]);
                nativeLibraryLoadable = true;
                initialized = true;
            }
            catch (Throwable t) {
                nativeLibraryLoadable = false;
                nativeLibraryLoadThrowable = t;
                LOG.warn((Object)("Native library not available on this platform: " + ThrowableUtil.getAllMessages((Throwable)t)));
                LOG.debug((Object)"Native library failure stack trace follows: ", t);
                disabled = true;
            }
        }
    }

    private static final Object invokeApi(NativeApi api, Object ... args) throws Throwable {
        AccessibleObject accessibleObject = nativeApis.get((Object)api);
        if (accessibleObject instanceof Method) {
            return ((Method)accessibleObject).invoke(null, args);
        }
        return ((Field)accessibleObject).get(null);
    }

    private static String findNativeLibrariesRootDirectory() throws Exception {
        String rootDir = null;
        File jniLocation = null;
        if (SystemInfoFactory.isNativeSystemInfoAvailable() && (rootDir = System.getProperty("rhq.native-libraries-root-directory")) == null) {
            URL jarLocation = Class.forName(NATIVE_LIBRARY_CLASS_NAME).getProtectionDomain().getCodeSource().getLocation();
            if (jarLocation != null) {
                jniLocation = new File(jarLocation.toURI()).getParentFile();
            }
            if (jniLocation != null && jniLocation.exists()) {
                rootDir = jniLocation.getAbsolutePath();
            } else {
                throw new Exception("Native JNI libraries cannot be found: jar-location=[" + jarLocation + "], jni-location=[" + jniLocation + "]");
            }
        }
        LOG.debug((Object)("Root directory to the native library is: " + rootDir));
        return rootDir;
    }

    private SystemInfoFactory() {
    }

    public static TemplateEngine fetchTemplateEngine() {
        try {
            String[] syspropsToSupport;
            SystemInfo systemInfo = SystemInfoFactory.createSystemInfo();
            HashMap<String, String> tokens = new HashMap<String, String>();
            for (String sysprop : syspropsToSupport = new String[]{"java.io.tmpdir", "file.separator", "line.separator", "path.separator", "java.home", "java.version", "user.timezone", "user.region", "user.country", "user.language"}) {
                tokens.put("rhq.system.sysprop." + sysprop, System.getProperty(sysprop, sysprop));
            }
            tokens.put("rhq.system.hostname", systemInfo.getHostname());
            tokens.put("rhq.system.os.name", systemInfo.getOperatingSystemName());
            tokens.put("rhq.system.os.version", systemInfo.getOperatingSystemVersion());
            tokens.put("rhq.system.os.type", systemInfo.getOperatingSystemType().toString());
            tokens.put("rhq.system.architecture", systemInfo.getSystemArchitecture());
            try {
                tokens.put("rhq.system.cpu.count", Integer.toString(systemInfo.getNumberOfCpus()));
            }
            catch (Exception e) {
                tokens.put("rhq.system.cpu.count", "?");
            }
            List<NetworkAdapterInfo> allNetworkAdapters = null;
            try {
                allNetworkAdapters = systemInfo.getAllNetworkAdapters();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (allNetworkAdapters != null) {
                for (NetworkAdapterInfo networkAdapter : allNetworkAdapters) {
                    String key = "rhq.system.interfaces." + networkAdapter.getName();
                    tokens.put(key + ".mac", networkAdapter.getMacAddressString());
                    tokens.put(key + ".type", networkAdapter.getType());
                    tokens.put(key + ".flags", networkAdapter.getAllFlags());
                    if (!networkAdapter.getUnicastAddresses().isEmpty()) {
                        tokens.put(key + ".address", networkAdapter.getUnicastAddresses().get(0).getHostAddress());
                    }
                    if (networkAdapter.getMulticastAddresses().isEmpty()) continue;
                    tokens.put(key + ".multicast.address", networkAdapter.getMulticastAddresses().get(0).getHostAddress());
                }
            }
            try {
                try {
                    tokens.put("rhq.system.interfaces.java.address", InetAddress.getByName(systemInfo.getHostname()).getHostAddress());
                }
                catch (Exception e) {
                    tokens.put("rhq.system.interfaces.java.address", InetAddress.getLocalHost().getHostAddress());
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            TemplateEngine templateEngine = new TemplateEngine(tokens);
            return templateEngine;
        }
        catch (Exception e) {
            return new TemplateEngine(new HashMap());
        }
    }

    static {
        initialized = false;
        threadFactory = new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("systeminfo-" + this.threadNumber.getAndIncrement());
                return t;
            }
        };
        executor = Executors.newCachedThreadPool(threadFactory);
        javaSystemInfo = new JavaSystemInfo(executor);
        nativeApis = new HashMap<NativeApi, AccessibleObject>();
    }

    private static enum NativeApi {
        load,
        VERSION_STRING,
        BUILD_DATE,
        NATIVE_VERSION_STRING,
        NATIVE_BUILD_DATE;

    }
}

