/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system.pquery;

import java.util.Arrays;
import org.rhq.core.system.pquery.Conditional;

class Attribute {
    private final String attributeValue;

    Attribute(String attributeValue, Conditional.Category category) {
        this.validate(attributeValue, category);
        this.attributeValue = attributeValue;
    }

    String getAttributeValue() {
        return this.attributeValue;
    }

    Integer getAttributeValueAsInteger() {
        try {
            return Integer.valueOf(this.attributeValue);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public String toString() {
        return this.attributeValue;
    }

    private void validate(String attribute, Conditional.Category category) {
        if (category.equals((Object)Conditional.Category.process)) {
            try {
                ProcessCategoryAttributes.valueOf(attribute);
                return;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid attribute [" + attribute + "] for category [" + (Object)((Object)category) + "]. Must be one of: " + Arrays.toString((Object[])ProcessCategoryAttributes.values()));
            }
        }
        if (category.equals((Object)Conditional.Category.arg)) {
            return;
        }
        throw new IllegalArgumentException("Attribute cannot be validated due to unknown category: " + (Object)((Object)category));
    }

    static enum ProcessCategoryAttributes {
        name,
        basename,
        pidfile,
        pid;

    }
}

