/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.obfuscation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;
import org.rhq.core.util.obfuscation.ObfuscatedPreferences;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;

public class PropertyObfuscationVault
implements SecurityVault {
    private static final Log LOG = LogFactory.getLog(SecurityVault.class);
    private static final String RESTRICTED = "restricted";
    private volatile Map<String, Object> options;

    public void init(Map<String, Object> options) throws SecurityVaultException {
        this.options = Collections.synchronizedMap(new HashMap());
        this.options.putAll(options);
    }

    public boolean isInitialized() {
        return true;
    }

    public byte[] handshake(Map<String, Object> handshakeOptions) throws SecurityVaultException {
        return null;
    }

    public Set<String> keyList() throws SecurityVaultException {
        return this.options.keySet();
    }

    public boolean exists(String vaultBlock, String attributeName) throws SecurityVaultException {
        return true;
    }

    public void store(String vaultBlock, String attributeName, char[] attributeValue, byte[] sharedKey) throws SecurityVaultException {
    }

    public char[] retrieve(String blockType, String systemProperty, byte[] defaultValue) throws SecurityVaultException {
        try {
            boolean isRestricted = false;
            if (RESTRICTED.equalsIgnoreCase(blockType)) {
                isRestricted = true;
            }
            char[] result = null;
            String systemPropertyValue = System.getProperty(systemProperty);
            if (systemPropertyValue != null && !systemPropertyValue.trim().isEmpty()) {
                if (isRestricted) {
                    String actualSystemPropertyValue = systemPropertyValue;
                    if (ObfuscatedPreferences.RestrictedFormat.isRestrictedFormat(actualSystemPropertyValue)) {
                        actualSystemPropertyValue = ObfuscatedPreferences.RestrictedFormat.retrieveValue(actualSystemPropertyValue);
                    }
                    try {
                        result = PicketBoxObfuscator.decode(actualSystemPropertyValue).toCharArray();
                    }
                    catch (Exception e) {
                        result = actualSystemPropertyValue.toCharArray();
                    }
                } else {
                    result = systemPropertyValue.toCharArray();
                }
            } else if (defaultValue != null && defaultValue.length != 0) {
                if (isRestricted) {
                    try {
                        result = PicketBoxObfuscator.decode(new String(defaultValue)).toCharArray();
                    }
                    catch (Exception e) {
                        result = new String(defaultValue).toCharArray();
                    }
                } else {
                    result = new String(defaultValue).toCharArray();
                }
            } else {
                throw new IllegalArgumentException();
            }
            return result;
        }
        catch (Exception e) {
            throw new SecurityVaultException((Throwable)e);
        }
    }

    public boolean remove(String vaultBlock, String attributeName, byte[] sharedKey) throws SecurityVaultException {
        return true;
    }
}

