/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.rhq.core.template.TemplateEngine;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.updater.DeploymentProperties;

public class DeploymentData {
    private DeploymentProperties deploymentProps;
    private Map<File, File> zipFiles;
    private Map<File, File> rawFiles;
    private File destinationDir;
    private File sourceDir;
    private Map<File, Pattern> zipEntriesToRealizeRegex;
    private Set<File> rawFilesToRealize;
    private TemplateEngine templateEngine;
    private Pattern ignoreRegex;
    private Map<File, Boolean> zipsExploded;

    @Deprecated
    public DeploymentData(DeploymentProperties deploymentProps, Set<File> zipFiles, Map<File, File> rawFiles, File sourceDir, File destinationDir, Map<File, Pattern> zipEntriesToRealizeRegex, Set<File> rawFilesToRealize, TemplateEngine templateEngine, Pattern ignoreRegex, boolean manageRootDir, Map<File, Boolean> zipsExploded) {
        HashMap<File, File> zipFilesMap;
        HashMap<File, File> hashMap = zipFilesMap = null == zipFiles ? null : new HashMap<File, File>(zipFiles.size());
        if (null != zipFiles) {
            for (File zipFile : zipFiles) {
                zipFilesMap.put(zipFile, null);
            }
        }
        deploymentProps.setManageRootDir(manageRootDir);
        this.init(deploymentProps, zipFilesMap, rawFiles, sourceDir, destinationDir, zipEntriesToRealizeRegex, rawFilesToRealize, templateEngine, ignoreRegex, zipsExploded);
    }

    @Deprecated
    public DeploymentData(DeploymentProperties deploymentProps, Set<File> zipFiles, Map<File, File> rawFiles, File sourceDir, File destinationDir, Map<File, Pattern> zipEntriesToRealizeRegex, Set<File> rawFilesToRealize, TemplateEngine templateEngine, Pattern ignoreRegex, Map<File, Boolean> zipsExploded) {
        HashMap<File, File> zipFilesMap;
        HashMap<File, File> hashMap = zipFilesMap = null == zipFiles ? null : new HashMap<File, File>(zipFiles.size());
        if (null != zipFiles) {
            for (File zipFile : zipFiles) {
                zipFilesMap.put(zipFile, null);
            }
        }
        this.init(deploymentProps, zipFilesMap, rawFiles, sourceDir, destinationDir, zipEntriesToRealizeRegex, rawFilesToRealize, templateEngine, ignoreRegex, zipsExploded);
    }

    public DeploymentData(DeploymentProperties deploymentProps, File sourceDir, File destinationDir, Map<File, File> rawFiles, Set<File> rawFilesToRealize, Map<File, File> zipFiles, Map<File, Pattern> zipEntriesToRealizeRegex, TemplateEngine templateEngine, Pattern ignoreRegex, Map<File, Boolean> zipsExploded) {
        this.init(deploymentProps, zipFiles, rawFiles, sourceDir, destinationDir, zipEntriesToRealizeRegex, rawFilesToRealize, templateEngine, ignoreRegex, zipsExploded);
    }

    private void init(DeploymentProperties deploymentProps, Map<File, File> zipFiles, Map<File, File> rawFiles, File sourceDir, File destinationDir, Map<File, Pattern> zipEntriesToRealizeRegex, Set<File> rawFilesToRealize, TemplateEngine templateEngine, Pattern ignoreRegex, Map<File, Boolean> zipsExploded) {
        if (deploymentProps == null) {
            throw new IllegalArgumentException("deploymentProps == null");
        }
        if (destinationDir == null) {
            throw new IllegalArgumentException("destinationDir == null");
        }
        if (sourceDir == null) {
            throw new IllegalArgumentException("sourceDir == null");
        }
        if (zipFiles == null) {
            zipFiles = new HashMap<File, File>(0);
        }
        if (rawFiles == null) {
            rawFiles = new HashMap<File, File>(0);
        }
        if (zipsExploded == null) {
            zipsExploded = new HashMap<File, Boolean>(0);
        }
        this.deploymentProps = deploymentProps;
        this.zipFiles = zipFiles;
        this.rawFiles = rawFiles;
        this.destinationDir = FileUtil.normalizePath(destinationDir.getAbsoluteFile());
        this.sourceDir = sourceDir;
        this.ignoreRegex = ignoreRegex;
        this.zipsExploded = zipsExploded;
        if (templateEngine == null || zipEntriesToRealizeRegex == null && rawFilesToRealize == null) {
            this.zipEntriesToRealizeRegex = null;
            this.rawFilesToRealize = null;
            this.templateEngine = null;
        } else {
            this.zipEntriesToRealizeRegex = zipEntriesToRealizeRegex;
            this.rawFilesToRealize = rawFilesToRealize;
            this.templateEngine = templateEngine;
        }
        for (Map.Entry<File, File> entry : this.rawFiles.entrySet()) {
            File rawFile = entry.getValue();
            if (null == rawFile) continue;
            String rawFilePath = rawFile.getPath();
            entry.setValue(this.getSafeFile(rawFile, rawFilePath));
        }
        for (Map.Entry<File, File> entry : this.zipFiles.entrySet()) {
            File zipFile = entry.getValue();
            if (null == zipFile) continue;
            String zipFilePath = zipFile.getPath();
            entry.setValue(this.getSafeFile(zipFile, zipFilePath));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getSafeFile(File file, String filePath) {
        boolean isWindows;
        boolean doubledot = filePath.replace('\\', '/').matches(".*((/\\.\\.)|(\\.\\./)).*");
        boolean bl = isWindows = File.separatorChar == '\\';
        if (doubledot) {
            File fileToNormalize;
            if (file.isAbsolute()) {
                fileToNormalize = file;
            } else if (isWindows) {
                StringBuilder filePathBuilder = new StringBuilder(filePath);
                String fileDriveLetter = FileUtil.stripDriveLetter(filePathBuilder);
                StringBuilder destDirAbsPathBuilder = new StringBuilder(this.destinationDir.getAbsolutePath());
                String destDirDriveLetter = FileUtil.stripDriveLetter(destDirAbsPathBuilder);
                if (destDirDriveLetter != null && fileDriveLetter != null && !fileDriveLetter.equals(destDirDriveLetter)) throw new IllegalArgumentException("Cannot normalize relative path [" + filePath + "]; its drive letter is different than the destination directory [" + this.destinationDir.getAbsolutePath() + "]");
                fileToNormalize = new File(this.destinationDir, filePathBuilder.toString());
            } else {
                fileToNormalize = new File(this.destinationDir, filePath);
            }
            fileToNormalize = DeploymentData.getNormalizedFile(fileToNormalize);
            if (!this.isPathUnderBaseDir(this.destinationDir, fileToNormalize)) return fileToNormalize;
            String baseDir = this.destinationDir.getAbsolutePath();
            String absFilePath = fileToNormalize.getAbsolutePath();
            String relativePath = absFilePath.substring(baseDir.length() + 1);
            return new File(relativePath);
        }
        if (!isWindows || file == null || !file.isAbsolute()) return file;
        return DeploymentData.getNormalizedFile(file);
    }

    private static File getNormalizedFile(File fileToNormalize) {
        return FileUtil.normalizePath(fileToNormalize);
    }

    public DeploymentProperties getDeploymentProps() {
        return this.deploymentProps;
    }

    @Deprecated
    public Set<File> getZipFiles() {
        return this.zipFiles.keySet();
    }

    public Map<File, File> getZipFilesMap() {
        return this.zipFiles;
    }

    public Map<File, File> getRawFiles() {
        return this.rawFiles;
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public Map<File, Pattern> getZipEntriesToRealizeRegex() {
        return this.zipEntriesToRealizeRegex;
    }

    public Set<File> getRawFilesToRealize() {
        return this.rawFilesToRealize;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public Pattern getIgnoreRegex() {
        return this.ignoreRegex;
    }

    @Deprecated
    public boolean isManageRootDir() {
        return this.deploymentProps.getManageRootDir();
    }

    public Map<File, Boolean> getZipsExploded() {
        return this.zipsExploded;
    }

    private boolean isPathUnderBaseDir(File base, File path) {
        if (base == null) {
            return false;
        }
        while (path != null) {
            if (base.equals(path)) {
                return true;
            }
            path = path.getParentFile();
        }
        return false;
    }
}

