/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.type;

import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.bundle.ant.type.AbstractBundleType;

public class FileSet
extends AbstractBundleType {
    private PatternSet defaultPatterns = new PatternSet();
    private File dir;

    public void setRefid(Reference r) throws BuildException {
        if (this.dir != null || this.defaultPatterns.hasPatterns((Project)this.getProject())) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public void setDir(String dir) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.dir = new File(dir);
    }

    public File getDir() {
        return this.isReference() ? this.getRef(this.getProject()).getDir() : this.dir;
    }

    public PatternSet.NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createInclude();
    }

    public void setFile(String file) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createInclude().setName(file);
    }

    public void setIncludes(String includes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludes(includes);
    }

    public String[] getIncludePatterns() {
        return this.defaultPatterns.getIncludePatterns((Project)this.getProject());
    }

    protected String getDataTypeName() {
        BundleAntProject p = this.getProject();
        if (p != null) {
            Hashtable typedefs = p.getDataTypeDefinitions();
            Enumeration e = typedefs.keys();
            while (e.hasMoreElements()) {
                String typeName = (String)e.nextElement();
                Class typeClass = (Class)typedefs.get(typeName);
                if (typeClass != ((Object)((Object)this)).getClass()) continue;
                return typeName;
            }
        }
        String classname = ((Object)((Object)this)).getClass().getName();
        return classname.substring(classname.lastIndexOf(46) + 1);
    }

    protected FileSet getRef(Project p) {
        if (!this.isChecked()) {
            Stack<FileSet> stk = new Stack<FileSet>();
            stk.push(this);
            this.dieOnCircularReference(stk, p);
        }
        Object o = this.getRefid().getReferencedObject(p);
        if (!((Object)((Object)this)).getClass().isAssignableFrom(o.getClass())) {
            throw new BuildException(this.getRefid().getRefId() + " doesn't denote a " + this.getDataTypeName());
        }
        return (FileSet)((Object)o);
    }

    public String toString() {
        String[] includes = this.getIncludePatterns();
        return Arrays.asList(includes).toString();
    }
}

