/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.DateParseException;
import liquibase.statement.DatabaseFunction;
import liquibase.util.ISODateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2Database
extends AbstractDatabase {
    private static String START_CONCAT = "CONCAT(";
    private static String END_CONCAT = ")";
    private static String SEP_CONCAT = ", ";
    private static List keywords = Arrays.asList("USER", "PASSWORD");

    public H2Database() {
        this.databaseFunctions.add(new DatabaseFunction("CURRENT_TIMESTAMP()"));
    }

    @Override
    public String getTypeName() {
        return "h2";
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:h2")) {
            return "org.h2.Driver";
        }
        return null;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return "H2".equals(conn.getDatabaseProductName());
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public String getViewDefinition(String schemaName, String name) throws DatabaseException {
        String definition = super.getViewDefinition(schemaName, name);
        if (!definition.startsWith("SELECT")) {
            definition = definition.replaceFirst(".*?\n", "");
        }
        definition = definition.replaceFirst("/\\*.*", "");
        return definition;
    }

    @Override
    public Date parseDate(String dateAsString) throws DateParseException {
        try {
            if (dateAsString.indexOf(32) > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS").parse(dateAsString);
            }
            if (dateAsString.indexOf(58) > 0) {
                return new SimpleDateFormat("HH:mm:ss").parse(dateAsString);
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(dateAsString);
        }
        catch (ParseException e) {
            throw new DateParseException(dateAsString);
        }
    }

    @Override
    public boolean isLocalDatabase() throws DatabaseException {
        String url = this.getConnection().getURL();
        boolean isLocalURL = super.isLocalDatabase() || url.startsWith("jdbc:h2:file:") || url.startsWith("jdbc:h2:mem:") || url.startsWith("jdbc:h2:zip:") || url.startsWith("jdbc:h2:~");
        return isLocalURL;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws DatabaseException {
        return "PUBLIC";
    }

    @Override
    public String getConcatSql(String ... values) {
        if (values == null) {
            return null;
        }
        return this.getConcatSql(Arrays.asList(values));
    }

    private String getConcatSql(List<String> values) {
        if (values.size() == 1) {
            return values.get(0);
        }
        return START_CONCAT + values.get(0) + SEP_CONCAT + this.getConcatSql(values.subList(1, values.size())) + END_CONCAT;
    }

    @Override
    public String getDateLiteral(String isoDate) {
        String returnString = isoDate;
        try {
            if (this.isDateTime(isoDate)) {
                ISODateFormat isoTimestampFormat = new ISODateFormat();
                SimpleDateFormat dbTimestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                returnString = dbTimestampFormat.format(isoTimestampFormat.parse(isoDate));
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("Unexpected date format: " + isoDate, e);
        }
        return "'" + returnString + "'";
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws DatabaseException {
        return super.convertRequestedSchemaToSchema(requestedSchema).toUpperCase();
    }

    @Override
    public String escapeDatabaseObject(String objectName) {
        if (objectName != null && this.isReservedWord(objectName)) {
            return "\"" + objectName.toUpperCase() + "\"";
        }
        return objectName;
    }

    @Override
    public boolean isReservedWord(String objectName) {
        return keywords.contains(objectName.toUpperCase());
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "NOW()";
    }
}

