/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "PostgreSQL";
    private Set<String> systemTablesAndViews = new HashSet<String>();
    private String defaultDatabaseSchemaName;
    private Set<String> reservedWords = new HashSet<String>(Arrays.asList("USER", "LIKE", "GROUP", "DATE", "ALL"));

    @Override
    public String getTypeName() {
        return "postgresql";
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        return null;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "NOW()";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws DatabaseException {
        block5: {
            if (this.defaultDatabaseSchemaName == null) {
                try {
                    List<String> searchPaths = this.getSearchPaths();
                    if (searchPaths == null || searchPaths.size() <= 0) break block5;
                    for (String searchPath : searchPaths) {
                        if (searchPath == null || searchPath.length() <= 0) continue;
                        this.defaultDatabaseSchemaName = searchPath;
                        if (this.defaultDatabaseSchemaName.equals("$user") && this.getConnection().getConnectionUserName() != null) {
                            this.defaultDatabaseSchemaName = !this.schemaExists(this.getConnection().getConnectionUserName()) ? null : this.getConnection().getConnectionUserName();
                        }
                        if (this.defaultDatabaseSchemaName == null) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LogFactory.getLogger().severe("Failed to get default catalog name from postgres", e);
                }
            }
        }
        return this.defaultDatabaseSchemaName;
    }

    @Override
    public String getDefaultCatalogName() throws DatabaseException {
        return "public";
    }

    @Override
    public String getDatabaseChangeLogTableName() {
        return super.getDatabaseChangeLogTableName().toLowerCase();
    }

    @Override
    public String getDatabaseChangeLogLockTableName() {
        return super.getDatabaseChangeLogLockTableName().toLowerCase();
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        return super.isSystemTable(catalogName, schemaName, tableName) || "pg_catalog".equals(schemaName) || "pg_toast".equals(schemaName) || tableName.endsWith("_seq") || tableName.endsWith("_key") || tableName.endsWith("_pkey") || tableName.startsWith("idx_") || tableName.startsWith("pk_");
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public String getAutoIncrementClause() {
        return "";
    }

    @Override
    public boolean generateAutoIncrementStartWith(BigInteger startWith) {
        return false;
    }

    @Override
    public boolean generateAutoIncrementBy(BigInteger incrementBy) {
        return false;
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws DatabaseException {
        if (requestedSchema == null) {
            requestedSchema = this.getDefaultSchemaName();
        }
        if (requestedSchema == null) {
            return this.getDefaultCatalogName();
        }
        String schema = StringUtils.trimToNull(requestedSchema);
        return schema != null ? schema.toLowerCase() : schema;
    }

    @Override
    public String convertRequestedSchemaToCatalog(String requestedSchema) throws DatabaseException {
        return super.convertRequestedSchemaToCatalog(requestedSchema);
    }

    @Override
    public String escapeDatabaseObject(String objectName) {
        if (objectName == null) {
            return null;
        }
        if (objectName.contains("-") || this.hasMixedCase(objectName) || this.startsWithNumeric(objectName) || this.isReservedWord(objectName)) {
            return "\"" + objectName + "\"";
        }
        return super.escapeDatabaseObject(objectName);
    }

    protected boolean hasMixedCase(String tableName) {
        return tableName.matches(".*[A-Z].*") && tableName.matches(".*[a-z].*");
    }

    private boolean startsWithNumeric(String tableName) {
        return tableName.matches("^[0-9].*");
    }

    @Override
    public boolean isReservedWord(String tableName) {
        return this.reservedWords.contains(tableName.toUpperCase());
    }

    private List<String> getSearchPaths() {
        ArrayList<String> searchPaths = null;
        try {
            String searchPathResult;
            DatabaseConnection con = this.getConnection();
            if (con != null && (searchPathResult = (String)ExecutorService.getInstance().getExecutor(this).queryForObject(new RawSqlStatement("SHOW search_path"), String.class)) != null) {
                String[] dirtySearchPaths = searchPathResult.split("\\,");
                searchPaths = new ArrayList<String>();
                for (String searchPath : dirtySearchPaths) {
                    if ((searchPath = searchPath.trim()).equals("\"$user\"")) {
                        searchPath = "$user";
                    }
                    searchPaths.add(searchPath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogFactory.getLogger().severe("Failed to get default catalog name from postgres", e);
        }
        return searchPaths;
    }

    private boolean catalogExists(String catalogName) throws DatabaseException {
        if (catalogName != null) {
            return this.runExistsQuery("select count(*) from information_schema.schemata where catalog_name='" + catalogName + "'");
        }
        return false;
    }

    private boolean schemaExists(String schemaName) throws DatabaseException {
        return schemaName != null && this.runExistsQuery("select count(*) from information_schema.schemata where schema_name='" + schemaName + "'");
    }

    private boolean runExistsQuery(String query) throws DatabaseException {
        Long count = ExecutorService.getInstance().getExecutor(this).queryForLong(new RawSqlStatement(query));
        return count != null && count > 0L;
    }

    @Override
    public String escapeIndexName(String schemaName, String indexName) {
        return indexName;
    }
}

