/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcCred;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.ProcTime;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.SigarProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.system.AggregateProcessInfo;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.SigarAccess;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoException;
import org.rhq.core.system.SystemInfoFactory;

public class ProcessInfo {
    private static final Log LOG = LogFactory.getLog(ProcessInfo.class);
    private static final int REFRESH_LOCK_ACQUIRE_TIMEOUT_SECONDS = 5;
    private static final String UNKNOWN_PROCESS_NAME = "?";
    private static final Set<String> MS_WINDOWS_TERMINATE_SIGNAL_NAMES = new HashSet<String>();
    protected boolean initialized;
    protected SigarProxy sigar;
    protected long pid;
    protected String name;
    protected String[] commandLine;
    protected Map<String, String> procEnv;
    protected Map<String, String> environmentVariables;
    protected String baseName;
    protected ProcessInfo parentProcess;
    @Deprecated
    protected ProcState procState;
    @Deprecated
    protected ProcExe procExe;
    @Deprecated
    protected ProcTime procTime;
    @Deprecated
    protected ProcMem procMem;
    @Deprecated
    protected ProcCpu procCpu;
    @Deprecated
    protected ProcFd procFd;
    @Deprecated
    protected ProcCred procCred;
    @Deprecated
    protected ProcCredName procCredName;
    protected boolean processDied;
    private boolean loggedPermissionsError = false;
    private ProcessInfoSnapshot snapshot = new ProcessInfoSnapshot();
    private ReentrantLock refreshLock = new ReentrantLock();

    protected ProcessInfo() {
    }

    public ProcessInfo(long pid) throws SystemInfoException {
        this(pid, SigarAccess.getSigar());
    }

    public ProcessInfo(long pid, SigarProxy sigar) throws SystemInfoException {
        this.pid = pid;
        this.sigar = sigar;
        this.update(pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws SystemInfoException {
        boolean acquiredLock = false;
        try {
            acquiredLock = this.refreshLock.tryLock(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Thread interrupted while trying to acquire ProcessInfo[" + this.pid + "] refresh lock"), (Throwable)e);
        }
        if (!acquiredLock) {
            throw new RuntimeException("Could not acquire ProcessInfo[" + this.pid + "] refresh lock");
        }
        try {
            if (this.priorSnaphot().isRunning()) {
                this.update(this.pid);
            }
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    private void update(long pid) throws SystemInfoException {
        long startTime = System.currentTimeMillis();
        try {
            this.processDied = false;
            ProcState procState = null;
            try {
                procState = this.sigar.getProcState(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcState");
            }
            ProcExe procExe = null;
            try {
                procExe = this.sigar.getProcExe(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcExe");
            }
            if (!this.initialized) {
                String[] procArgs = null;
                try {
                    procArgs = this.sigar.getProcArgs(pid);
                }
                catch (Exception e) {
                    this.handleSigarCallException(e, "getProcArgs");
                }
                this.name = this.determineName(procArgs, procExe, procState);
                this.commandLine = procArgs != null ? procArgs : new String[]{};
                this.procEnv = null;
                try {
                    this.procEnv = this.sigar.getProcEnv(pid);
                    if (this.procEnv == null) {
                        LOG.debug((Object)("SIGAR returned a null environment for [" + this.getBaseName() + "] process with pid [" + this.pid + "]."));
                    }
                }
                catch (Exception e) {
                    this.handleSigarCallException(e, "getProcEnv");
                }
                this.initialized = true;
            }
            this.procState = procState;
            this.procExe = procExe;
            try {
                this.procTime = this.sigar.getProcTime(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcTime");
            }
            try {
                this.procMem = this.sigar.getProcMem(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcMem");
            }
            try {
                this.procCpu = this.sigar.getProcCpu(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcCpu");
            }
            try {
                this.procFd = this.sigar.getProcFd(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcFd");
            }
            try {
                this.procCred = this.sigar.getProcCred(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcCred");
            }
            try {
                this.procCredName = this.sigar.getProcCredName(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcCredName");
            }
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
        if (LOG.isTraceEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            LOG.trace((Object)("Retrieval of process info for pid " + pid + " took " + elapsedTime + " ms."));
        }
        this.processDied = false;
    }

    public ProcessInfoSnapshot priorSnaphot() {
        return this.snapshot;
    }

    public ProcessInfoSnapshot freshSnapshot() {
        this.refresh();
        return this.snapshot;
    }

    public void destroy() throws SystemInfoException {
        if (this.sigar instanceof Sigar) {
            try {
                ((Sigar)this.sigar).close();
            }
            catch (RuntimeException e) {
                throw new SystemInfoException(e);
            }
        }
    }

    private void handleSigarCallException(Exception e, String methodName) {
        String procName;
        if (this.processDied) {
            return;
        }
        if (OperatingSystem.IS_WIN32 && (this.pid == 0L || this.pid == 4L)) {
            return;
        }
        String string = procName = this.baseName != null ? this.baseName : "<unknown>";
        if (e instanceof SigarPermissionDeniedException) {
            if (!this.loggedPermissionsError) {
                String currentUserName = System.getProperty("user.name");
                LOG.trace((Object)("Unable to obtain all info for [" + procName + "] process with pid [" + this.pid + "] - call to " + methodName + "failed. " + "The process is most likely owned by a user other than the user that owns the RHQ plugin container's process (" + currentUserName + ")."));
                this.loggedPermissionsError = true;
            }
        } else if (e instanceof SigarNotImplementedException) {
            LOG.trace((Object)("Unable to obtain all info for [" + procName + "] process with pid [" + this.pid + "] - call to " + methodName + "failed. Cause: " + e));
        } else {
            if (!this.exists()) {
                LOG.debug((Object)("Attempt to refresh info for process with pid [" + this.pid + "] failed, because the process is no longer running."));
                this.processDied = true;
            }
            LOG.debug((Object)("Unexpected error occurred while looking up info for [" + procName + "] process with pid [" + this.pid + "] - call to " + methodName + " failed. Did the process die? Cause: " + e));
        }
    }

    private boolean exists() {
        long[] pids;
        try {
            pids = this.sigar.getProcList();
        }
        catch (SigarException e1) {
            LOG.error((Object)"Failed to obtain process list.", (Throwable)e1);
            return true;
        }
        boolean foundProcess = false;
        for (long pid : pids) {
            if (pid != this.pid) continue;
            foundProcess = true;
            break;
        }
        return foundProcess;
    }

    private String determineName(String[] procArgs, ProcExe procExe, ProcState procState) {
        String stateName;
        String name = procArgs != null && procArgs.length != 0 ? procArgs[0] : (procExe != null && procExe.getName() != null ? procExe.getName() : (procState != null && procState.getName() != null ? ((stateName = procState.getName()).indexOf(File.separatorChar) >= 0 && new File(stateName).exists() ? stateName : UNKNOWN_PROCESS_NAME) : UNKNOWN_PROCESS_NAME));
        return name;
    }

    public long getPid() {
        return this.pid;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        if (this.baseName == null) {
            this.baseName = this.getName() != null ? new File(this.getName()).getName() : UNKNOWN_PROCESS_NAME;
        }
        return this.baseName;
    }

    public String[] getCommandLine() {
        return this.commandLine;
    }

    public Map<String, String> getEnvironmentVariables() {
        if (this.procEnv == null) {
            return Collections.emptyMap();
        }
        if (this.environmentVariables == null) {
            boolean isWindows;
            this.environmentVariables = new HashMap<String, String>(this.procEnv.size());
            SystemInfo systemInfo = SystemInfoFactory.createJavaSystemInfo();
            boolean bl = isWindows = systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS;
            if (isWindows) {
                for (Map.Entry<String, String> env : this.procEnv.entrySet()) {
                    this.environmentVariables.put(env.getKey().toUpperCase(), env.getValue());
                }
            } else {
                this.environmentVariables.putAll(this.procEnv);
            }
        }
        return this.environmentVariables;
    }

    @Nullable
    public String getEnvironmentVariable(@NotNull String name) {
        if (this.procEnv == null) {
            return null;
        }
        SystemInfo systemInfo = SystemInfoFactory.createJavaSystemInfo();
        boolean isWindows = systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS;
        return this.getEnvironmentVariables().get(isWindows ? name.toUpperCase() : name);
    }

    @Deprecated
    public long getParentPid() throws SystemInfoException {
        return this.priorSnaphot().getParentPid();
    }

    @Deprecated
    public ProcState getState() throws SystemInfoException {
        return this.priorSnaphot().getState();
    }

    @Deprecated
    public ProcExe getExecutable() throws SystemInfoException {
        return this.priorSnaphot().getExecutable();
    }

    @Deprecated
    public ProcTime getTime() throws SystemInfoException {
        return this.priorSnaphot().getTime();
    }

    @Deprecated
    public ProcMem getMemory() throws SystemInfoException {
        return this.priorSnaphot().getMemory();
    }

    @Deprecated
    public ProcCpu getCpu() throws SystemInfoException {
        return this.priorSnaphot().getCpu();
    }

    @Deprecated
    public ProcFd getFileDescriptor() throws SystemInfoException {
        return this.priorSnaphot().getFileDescriptor();
    }

    @Deprecated
    public ProcCred getCredentials() throws SystemInfoException {
        return this.priorSnaphot().getCredentials();
    }

    @Deprecated
    public ProcCredName getCredentialsName() throws SystemInfoException {
        return this.priorSnaphot().getCredentialsName();
    }

    @Deprecated
    public String getCurrentWorkingDirectory() throws SystemInfoException {
        return this.priorSnaphot().getCurrentWorkingDirectory();
    }

    @Deprecated
    public boolean isRunning() throws SystemInfoException {
        return this.priorSnaphot().isRunning();
    }

    public AggregateProcessInfo getAggregateProcessTree() {
        AggregateProcessInfo root = new AggregateProcessInfo(this.pid);
        return root;
    }

    public ProcessInfo getParentProcess() throws SystemInfoException {
        if (this.parentProcess == null) {
            this.parentProcess = new ProcessInfo(this.priorSnaphot().getParentPid(), this.sigar);
        } else {
            this.parentProcess.refresh();
        }
        return this.parentProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(String signalName) throws SigarException {
        int signalNumber = ProcessInfo.getSignalNumber(signalName);
        Sigar fullSigar = new Sigar();
        try {
            fullSigar.kill(this.pid, signalNumber);
        }
        finally {
            fullSigar.close();
        }
    }

    public int hashCode() {
        return Long.valueOf(this.pid).intValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ProcessInfo)) {
            return false;
        }
        return this.pid == ((ProcessInfo)obj).pid;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("process: ");
        s.append("pid=[");
        s.append(this.getPid());
        s.append("], name=[");
        s.append(!this.getName().equals(UNKNOWN_PROCESS_NAME) ? this.getName() : this.getBaseName());
        s.append("], ppid=[");
        try {
            s.append(this.priorSnaphot().getParentPid());
        }
        catch (Exception e) {
            s.append(e);
        }
        s.append("]");
        return s.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getSignalNumber(String signalName) {
        if (signalName == null) {
            throw new IllegalArgumentException("Signal name is null.");
        }
        if (OperatingSystem.IS_WIN32) {
            if (!MS_WINDOWS_TERMINATE_SIGNAL_NAMES.contains(signalName)) throw new IllegalArgumentException("Unsupported signal name: " + signalName + " - on Windows, the only supported signal names are " + MS_WINDOWS_TERMINATE_SIGNAL_NAMES + ", all of which return 1.");
            return 1;
        }
        int signalNumber = Sigar.getSigNum((String)signalName);
        if (signalNumber != -1) return signalNumber;
        throw new IllegalArgumentException("Unknown signal name: " + signalName);
    }

    static {
        MS_WINDOWS_TERMINATE_SIGNAL_NAMES.add("INT");
        MS_WINDOWS_TERMINATE_SIGNAL_NAMES.add("KILL");
        MS_WINDOWS_TERMINATE_SIGNAL_NAMES.add("QUIT");
        MS_WINDOWS_TERMINATE_SIGNAL_NAMES.add("TERM");
    }

    public final class ProcessInfoSnapshot {
        public long getParentPid() throws SystemInfoException {
            return ProcessInfo.this.procState != null ? ProcessInfo.this.procState.getPpid() : 0L;
        }

        public ProcState getState() throws SystemInfoException {
            return ProcessInfo.this.procState;
        }

        public ProcExe getExecutable() throws SystemInfoException {
            return ProcessInfo.this.procExe;
        }

        public ProcTime getTime() throws SystemInfoException {
            return ProcessInfo.this.procTime;
        }

        public ProcMem getMemory() throws SystemInfoException {
            return ProcessInfo.this.procMem;
        }

        public ProcCpu getCpu() throws SystemInfoException {
            return ProcessInfo.this.procCpu;
        }

        public ProcFd getFileDescriptor() throws SystemInfoException {
            return ProcessInfo.this.procFd;
        }

        public ProcCred getCredentials() throws SystemInfoException {
            return ProcessInfo.this.procCred;
        }

        public ProcCredName getCredentialsName() throws SystemInfoException {
            return ProcessInfo.this.procCredName;
        }

        public String getCurrentWorkingDirectory() throws SystemInfoException {
            String result = null;
            try {
                if (null != ProcessInfo.this.procExe) {
                    result = ProcessInfo.this.procExe.getCwd();
                }
            }
            catch (Exception e) {
                ProcessInfo.this.handleSigarCallException(e, "procExe.getCwd()");
            }
            return result;
        }

        public boolean isRunning() throws SystemInfoException {
            boolean running = false;
            if (ProcessInfo.this.procState != null) {
                running = ProcessInfo.this.procState.getState() == 'R' || ProcessInfo.this.procState.getState() == 'S' || ProcessInfo.this.procState.getState() == 'D';
            }
            return running;
        }
    }
}

