/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.Sigar;
import org.rhq.core.system.SystemInfoException;
import org.rhq.core.system.SystemInfoFactory;

class SigarAccessHandler
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(SigarAccessHandler.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int SHARED_SIGAR_LOCK_MAX_WAIT = Integer.getInteger("sharedSigarLockMaxWait", 2);
    private static final int LOCAL_SIGAR_INSTANCES_WARNING_THRESHOLD = Integer.getInteger("localSigarInstancesWarningThreshold", 50);
    private static final int MAX_LOCAL_SIGAR_INSTANCES = Integer.getInteger("maxLocalSigarInstances", 50);
    private static final boolean LIMIT_LOCAL_SIGAR_INSTANCES = MAX_LOCAL_SIGAR_INSTANCES > 0;
    private static final boolean THREAD_DUMP_ON_SIGAR_INSTANCES_THRESHOLD = Boolean.getBoolean("threadDumpOnlocalSigarInstancesWarningThreshold");
    private final SigarFactory sigarFactory;
    private final ReentrantLock sharedSigarLock;
    private final ReentrantLock localSigarLock;
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile int localSigarInstancesCount;
    private Sigar sharedSigar;

    SigarAccessHandler() {
        this(new DefaultSigarFactory());
    }

    SigarAccessHandler(SigarFactory sigarFactory) {
        this.sigarFactory = sigarFactory;
        this.sharedSigarLock = new ReentrantLock();
        this.localSigarLock = new ReentrantLock();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.scheduleWithFixedDelay(new ThresholdChecker(), 1L, 5L, TimeUnit.MINUTES);
        this.localSigarInstancesCount = 0;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (SystemInfoFactory.isNativeSystemInfoDisabled()) {
            throw new SystemInfoException("Native system has been disabled");
        }
        boolean acquiredLock = this.sharedSigarLock.tryLock(SHARED_SIGAR_LOCK_MAX_WAIT, TimeUnit.SECONDS);
        if (acquiredLock) {
            if (this.sharedSigar == null) {
                this.sharedSigar = this.sigarFactory.createSigarInstance();
            }
            try {
                Object object = method.invoke((Object)this.sharedSigar, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            finally {
                this.sharedSigarLock.unlock();
            }
        }
        Sigar localSigar = this.createLocalSigarInstance();
        try {
            Object object = method.invoke((Object)localSigar, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            this.closeLocalSigarInstance(localSigar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sigar createLocalSigarInstance() {
        this.localSigarLock.lock();
        try {
            if (LIMIT_LOCAL_SIGAR_INSTANCES && this.localSigarInstancesCount >= MAX_LOCAL_SIGAR_INSTANCES) {
                throw new RuntimeException("Too many Sigar instances created");
            }
            Sigar sigarInstance = this.sigarFactory.createSigarInstance();
            ++this.localSigarInstancesCount;
            Sigar sigar = sigarInstance;
            return sigar;
        }
        finally {
            this.localSigarLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLocalSigarInstance(Sigar sigar) {
        this.localSigarLock.lock();
        try {
            sigar.close();
            --this.localSigarInstancesCount;
        }
        finally {
            this.localSigarLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.sharedSigar != null) {
            this.sharedSigarLock.lock();
            try {
                this.sharedSigar.close();
                this.sharedSigar = null;
            }
            finally {
                this.sharedSigarLock.unlock();
            }
        }
        this.scheduledExecutorService.shutdownNow();
    }

    int localSigarInstancesCount() {
        return this.localSigarInstancesCount;
    }

    private class ThresholdChecker
    implements Runnable {
        private ThresholdChecker() {
        }

        @Override
        public void run() {
            int currentCount = SigarAccessHandler.this.localSigarInstancesCount;
            if (currentCount > LOCAL_SIGAR_INSTANCES_WARNING_THRESHOLD) {
                StringBuilder sb = new StringBuilder();
                sb.append("There are ").append(currentCount).append(" local Sigar instances currently active. ").append("This may indicate that a call to the shared Sigar instance did not complete.");
                if (THREAD_DUMP_ON_SIGAR_INSTANCES_THRESHOLD) {
                    sb.append(LINE_SEPARATOR);
                    this.threadDump(sb);
                }
                LOG.warn((Object)sb.toString());
            }
        }

        private void threadDump(StringBuilder sb) {
            ThreadInfo[] threadInfos;
            for (ThreadInfo threadInfo : threadInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                sb.append(threadInfo);
                sb.append(LINE_SEPARATOR);
            }
        }
    }

    private static class DefaultSigarFactory
    implements SigarFactory {
        private DefaultSigarFactory() {
        }

        @Override
        public Sigar createSigarInstance() {
            return new Sigar();
        }
    }

    static interface SigarFactory {
        public Sigar createSigarInstance();
    }
}

