/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas.node;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.node.AugeasNodeBase;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeException;

public class AugeasNodeLazy
extends AugeasNodeBase
implements AugeasNode {
    public AugeasNodeLazy(String fullPath, AugeasTree ag) {
        this.ag = ag;
        this.path = fullPath.substring(0, fullPath.lastIndexOf(File.separatorChar) + 1);
        String val = fullPath.substring(fullPath.lastIndexOf(File.separatorChar) + 1, fullPath.length());
        int firstB = val.indexOf("[");
        if (firstB != -1) {
            this.seq = Integer.valueOf(val.substring(firstB + 1, val.indexOf(93)));
            this.label = val.substring(0, firstB);
        } else {
            this.seq = 0;
            this.label = fullPath.substring(fullPath.lastIndexOf(File.separatorChar) + 1);
        }
    }

    @Override
    public List<AugeasNode> getChildNodes() {
        List<AugeasNode> nodes = null;
        nodes = this.ag.match(this.getFullPath() + File.separatorChar + "*");
        return nodes;
    }

    @Override
    public AugeasNode getParentNode() {
        String parentNodePath = this.path.substring(0, this.path.length() - 1);
        if (parentNodePath.equals(this.ag.getRootNode().getFullPath())) {
            return this.ag.getRootNode();
        }
        try {
            this.parentNode = this.ag.getNode(parentNodePath);
        }
        catch (AugeasTreeException e) {
            return null;
        }
        return this.parentNode;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = this.ag.get(this.getFullPath());
        }
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AugeasNode that = (AugeasNode)obj;
        return this.getFullPath().equals(that.getFullPath());
    }

    @Override
    public void setValue(String value) {
        this.ag.setValue(this, value);
    }

    @Override
    public String getFullPath() {
        return this.path + this.label + (this.seq != 0 ? "[" + String.valueOf(this.seq) + "]" : "");
    }

    @Override
    public void addChildNode(AugeasNode node) {
        this.childNodes.add(node);
    }

    @Override
    public List<AugeasNode> getChildByLabel(String labelName) {
        List<AugeasNode> nodes = this.getChildNodes();
        ArrayList<AugeasNode> tempNode = new ArrayList<AugeasNode>();
        for (AugeasNode node : nodes) {
            if (!node.getLabel().equals(labelName)) continue;
            tempNode.add(node);
        }
        return tempNode;
    }

    @Override
    public void remove(boolean updateSeq) throws AugeasTreeException {
        this.ag.removeNode(this, updateSeq);
    }

    @Override
    public void setPath(String path) throws AugeasTreeException {
        this.path = path;
    }

    @Override
    public void updateFromParent() {
        AugeasNode node = this.getParentNode();
        if (!this.path.equals(node.getFullPath())) {
            this.path = node.getFullPath();
        }
    }
}

