/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.augeas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.plugin.PluginContext;
import org.rhq.core.pluginapi.plugin.PluginLifecycleListener;
import org.rhq.core.util.stream.StreamUtil;

public class AugeasPluginLifecycleListener
implements PluginLifecycleListener {
    private static final Log LOG = LogFactory.getLog(AugeasPluginLifecycleListener.class);
    public static final String LENSES_SUBDIRECTORY_NAME = "augeas-lenses";

    public void initialize(PluginContext context) throws Exception {
        List<String> lenses = this.getLenses(context.getPluginName());
        File lensesDir = AugeasPluginLifecycleListener.ensureLensesDirExists(context.getDataDirectory(), context.getPluginName());
        this.copyToDir(lenses, lensesDir, context.getPluginName());
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLenses(String pluginName) throws IOException {
        InputStream lensesDescriptor = this.getClass().getResourceAsStream("/META-INF/augeas-lenses/list");
        if (lensesDescriptor == null) {
            return Collections.emptyList();
        }
        BufferedReader rdr = null;
        try {
            String line;
            rdr = new BufferedReader(new InputStreamReader(lensesDescriptor, "UTF-8"));
            ArrayList<String> ret = new ArrayList<String>();
            while ((line = rdr.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                ret.add(line.trim());
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
        finally {
            try {
                rdr.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to close the reader of the 'META-INF/augeas-lenses/list' file in the plugin jar of plugin '" + pluginName + "'."));
            }
        }
    }

    private void copyToDir(List<String> lenses, File targetDir, String pluginName) throws IOException {
        for (String lens : lenses) {
            URL lensURL = null;
            lensURL = lens.startsWith("/") ? this.getClass().getResource(lens) : this.getClass().getResource("/META-INF/augeas-lenses/" + lens);
            String lensName = lensURL.getPath();
            if (lensName.indexOf(47) >= 0) {
                lensName = lensName.substring(lensName.lastIndexOf(47) + 1);
            }
            AugeasPluginLifecycleListener.copyURLToFile(lensURL, new File(targetDir, lensName));
        }
    }

    private static File ensureLensesDirExists(File dataDir, String pluginName) {
        if (!dataDir.exists() && !dataDir.mkdir()) {
            throw new IllegalStateException("Failed to create the data directory for plugin '" + pluginName + "'.");
        }
        File lensesDir = new File(dataDir, LENSES_SUBDIRECTORY_NAME);
        if (lensesDir.exists()) {
            for (File f : lensesDir.listFiles()) {
                f.delete();
            }
        } else if (!lensesDir.mkdir()) {
            throw new IllegalStateException("Failed to create the lenses subdirectory under the data directory for plugin '" + pluginName + "'.");
        }
        return lensesDir;
    }

    private static void copyURLToFile(URL source, File target) throws IOException {
        InputStream sourceStream = source.openStream();
        FileOutputStream targetStream = new FileOutputStream(target);
        StreamUtil.copy((InputStream)sourceStream, (OutputStream)targetStream, (boolean)true);
    }
}

