/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.augeas.Augeas;
import net.augeas.AugeasException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.config.AugeasConfiguration;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeBuilder;
import org.rhq.augeas.tree.AugeasTreeException;
import org.rhq.augeas.tree.impl.DefaultAugeasTreeBuilder;

public class AugeasProxy {
    private final Log log = LogFactory.getLog(this.getClass());
    private AugeasConfiguration config;
    private Augeas augeas;
    private List<String> modules;
    private AugeasTreeBuilder augeasTreeBuilder;

    public AugeasProxy(AugeasConfiguration config) {
        this(config, new DefaultAugeasTreeBuilder());
    }

    public AugeasProxy(AugeasConfiguration config, AugeasTreeBuilder builder) {
        this.config = config;
        this.augeasTreeBuilder = builder;
        this.modules = new ArrayList<String>();
    }

    public AugeasConfiguration getConfiguration() {
        return this.config;
    }

    public AugeasTreeBuilder getTreeBuilder() {
        return this.augeasTreeBuilder;
    }

    public void load() throws AugeasTreeException {
        try {
            this.config.loadFiles();
            if (this.augeas != null) {
                try {
                    this.augeas.close();
                }
                catch (Exception e) {
                    this.log.error((Object)"Could not close augeas instance", (Throwable)e);
                }
            }
            this.augeas = new Augeas(this.config.getRootPath(), this.config.getLoadPath(), this.config.getMode());
            for (AugeasModuleConfig module : this.config.getModules()) {
                this.modules.add(module.getModuletName());
                this.augeas.set("/augeas/load/" + module.getModuletName() + "/lens", module.getLensPath());
                int idx = 1;
                for (String incl : module.getConfigFiles()) {
                    this.augeas.set("/augeas/load/" + module.getModuletName() + "/incl[" + idx++ + "]", incl);
                }
            }
            this.augeas.load();
        }
        catch (NoClassDefFoundError e) {
            throw new AugeasException("Failed to initialize Augeas. It is probably not installed.", (Throwable)e);
        }
        catch (Exception e) {
            throw new AugeasException((Throwable)e);
        }
    }

    public AugeasTree getAugeasTree(String moduleName, boolean lazy) throws AugeasTreeException {
        AugeasTree tree;
        if (!this.modules.contains(moduleName)) {
            throw new AugeasTreeException("Augeas Module " + moduleName + " not found.");
        }
        try {
            if (this.augeas == null) {
                this.load();
            }
        }
        catch (Exception e) {
            throw new AugeasTreeException("Loading of augeas failed");
        }
        try {
            tree = this.augeasTreeBuilder.buildTree(this, this.config, moduleName, lazy);
        }
        catch (Exception e) {
            throw new AugeasTreeException("Error building Augeas tree.", e);
        }
        return tree;
    }

    public String printTree(String path) {
        StringBuilder builder = new StringBuilder();
        builder.append(path).append("    ").append(this.augeas.get(path)).append('\n');
        List list = this.augeas.match(path + File.separatorChar + "*");
        for (String tempStr : list) {
            builder.append(this.printTree(tempStr));
        }
        return builder.toString();
    }

    public Augeas getAugeas() {
        return this.augeas;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (this.augeas != null) {
            try {
                this.augeas.close();
            }
            catch (Exception e) {
                this.log.error((Object)"Could not close augeas instance", (Throwable)e);
            }
            this.augeas = null;
        }
    }
}

