/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.AugeasProxy;
import org.rhq.augeas.config.AugeasConfiguration;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeBuilder;

public abstract class AugeasComponent {
    AugeasProxy augeasProxy;
    boolean isClosed = true;
    private final Log log = LogFactory.getLog(this.getClass());

    public abstract AugeasConfiguration initConfiguration();

    public abstract AugeasTreeBuilder initTreeBuilder();

    protected void reloadAugeas() {
        if (!this.isClosed) {
            this.close();
        }
        this.augeasProxy = new AugeasProxy(this.initConfiguration(), this.initTreeBuilder());
        this.augeasProxy.load();
        this.isClosed = false;
    }

    public AugeasTree getAugeasTree(String moduleName) {
        this.reloadAugeas();
        return this.augeasProxy.getAugeasTree(moduleName, true);
    }

    public void close() {
        this.isClosed = true;
        if (this.augeasProxy != null) {
            try {
                this.augeasProxy.close();
            }
            catch (Exception e) {
                this.log.error((Object)"Could not close augeas instance", (Throwable)e);
            }
        }
    }

    public AugeasConfiguration getConfiguration() {
        if (this.augeasProxy == null) {
            throw new RuntimeException("Could not provide augeas configuration because augeas was not initialized yet.");
        }
        return this.augeasProxy.getConfiguration();
    }
}

