/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.cassandra;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.CassandraClusterManager;
import org.rhq.cassandra.ClusterInitService;
import org.rhq.cassandra.DeployCluster;
import org.rhq.cassandra.DeploymentOptions;
import org.rhq.cassandra.DeploymentOptionsFactory;
import org.rhq.cassandra.ShutdownCluster;
import org.rhq.cassandra.schema.SchemaManager;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;

public class CCMTestNGListener
implements IInvokedMethodListener {
    private final Log log = LogFactory.getLog(CCMTestNGListener.class);
    private CassandraClusterManager ccm;

    public void beforeInvocation(IInvokedMethod invokedMethod, ITestResult testResult) {
        Method method = invokedMethod.getTestMethod().getConstructorOrMethod().getMethod();
        if (method.isAnnotationPresent(DeployCluster.class)) {
            try {
                this.deployCluster(method.getAnnotation(DeployCluster.class));
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to deploy cluster", (Throwable)e);
            }
        }
    }

    public void afterInvocation(IInvokedMethod invokedMethod, ITestResult testResult) {
        Method method = invokedMethod.getTestMethod().getConstructorOrMethod().getMethod();
        if (method.isAnnotationPresent(ShutdownCluster.class)) {
            try {
                Boolean skipShutdown = Boolean.valueOf(System.getProperty("rhq.storage.cluster.skip-shutdown", "false"));
                if (!skipShutdown.booleanValue()) {
                    this.shutdownCluster();
                }
            }
            catch (Exception e) {
                this.log.warn((Object)"An error occurred while shutting down the cluster", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployCluster(DeployCluster annotation) throws Exception {
        boolean deploy = Boolean.valueOf(System.getProperty("rhq.storage.cluster.deploy", "true"));
        if (!deploy) {
            return;
        }
        String clusterDir = System.getProperty("rhq.storage.cluster.dir");
        if (clusterDir == null || clusterDir.isEmpty()) {
            File basedir = new File("target");
            clusterDir = new File(basedir, "cassandra").getAbsolutePath();
        }
        int numNodes = annotation.numNodes();
        DeploymentOptionsFactory factory = new DeploymentOptionsFactory();
        DeploymentOptions deploymentOptions = factory.newDeploymentOptions();
        deploymentOptions.setClusterDir(clusterDir);
        deploymentOptions.setNumNodes(numNodes);
        deploymentOptions.setUsername(annotation.username());
        deploymentOptions.setPassword(annotation.password());
        deploymentOptions.setStartRpc(Boolean.valueOf(true));
        deploymentOptions.setHeapSize("256M");
        deploymentOptions.setHeapNewSize("64M");
        this.ccm = new CassandraClusterManager(deploymentOptions);
        ClusterInitService clusterInitService = new ClusterInitService();
        this.ccm.createCluster();
        String[] nodes = this.ccm.getNodes();
        int[] jmxPorts = this.ccm.getJmxPorts();
        if (System.getProperty("rhq.storage.cluster.skip-shutdown") == null) {
            for (int index = 0; index < nodes.length; ++index) {
                try {
                    if (!clusterInitService.isNativeTransportRunning(nodes[index], jmxPorts[index])) continue;
                    throw new RuntimeException("A cluster is already running on the same ports.");
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to check whether node is running.", e);
                }
            }
        }
        this.ccm.startCluster(false);
        clusterInitService.waitForClusterToStart(nodes, jmxPorts, nodes.length, 2000L, 20, 10);
        SchemaManager schemaManager = new SchemaManager(annotation.username(), annotation.password(), nodes, this.ccm.getCqlPort());
        try {
            schemaManager.install();
            if (annotation.waitForSchemaAgreement()) {
                clusterInitService.waitForSchemaAgreement(nodes, jmxPorts);
            }
            schemaManager.updateTopology();
        }
        finally {
            schemaManager.shutdown();
        }
    }

    private void shutdownCluster() throws Exception {
        this.ccm.shutdownCluster();
    }
}

