/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.drift;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.rhq.common.drift.ChangeSetWriter;
import org.rhq.common.drift.FileEntry;
import org.rhq.common.drift.Headers;

public class ChangeSetWriterImpl
implements ChangeSetWriter {
    private Writer writer;
    private File changeSetFile;

    public ChangeSetWriterImpl(File changeSetFile, Headers headers) throws IOException {
        this.changeSetFile = changeSetFile;
        this.writer = new BufferedWriter(new FileWriter(this.changeSetFile));
        this.writeHeaders(headers);
    }

    private void writeHeaders(Headers headers) throws IOException {
        this.writer.write(headers.getResourceId() + "\n");
        this.writer.write(headers.getDriftDefinitionId() + "\n");
        this.writer.write(headers.getDriftDefinitionName() + "\n");
        this.writer.write(headers.getBasedir() + "\n");
        this.writer.write(headers.getType().code() + "\n");
        this.writer.write(headers.getVersion() + "\n");
    }

    @Override
    public void write(FileEntry entry) throws IOException {
        switch (entry.getType()) {
            case FILE_ADDED: {
                this.writer.write(entry.getType().code() + " " + entry.getNewSHA() + " 0 " + entry.getFile() + "\n");
                break;
            }
            case FILE_CHANGED: {
                this.writer.write(entry.getType().code() + " " + entry.getNewSHA() + " " + entry.getOldSHA() + " " + entry.getFile() + "\n");
                break;
            }
            case FILE_REMOVED: {
                this.writer.write(entry.getType().code() + " 0 " + entry.getOldSHA() + " " + entry.getFile() + "\n");
            }
        }
    }

    File getChangeSetFile() {
        return this.changeSetFile;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

