/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.common.drift;

import java.io.Serializable;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.core.util.file.FileUtil;

public class FileEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String file;
    private String oldSHA;
    private String newSHA;
    private DriftCategory type;

    public static FileEntry removedFileEntry(String file, String sha) {
        FileEntry entry = new FileEntry();
        entry.file = FileUtil.useForwardSlash((String)file);
        entry.oldSHA = sha;
        entry.newSHA = "0";
        entry.type = DriftCategory.FILE_REMOVED;
        return entry;
    }

    public static FileEntry addedFileEntry(String file, String sha) {
        FileEntry entry = new FileEntry();
        entry.file = FileUtil.useForwardSlash((String)file);
        entry.oldSHA = "0";
        entry.newSHA = sha;
        entry.type = DriftCategory.FILE_ADDED;
        return entry;
    }

    public static FileEntry changedFileEntry(String file, String oldSHA, String newSHA) {
        FileEntry entry = new FileEntry();
        entry.file = FileUtil.useForwardSlash((String)file);
        entry.oldSHA = oldSHA;
        entry.newSHA = newSHA;
        entry.type = DriftCategory.FILE_CHANGED;
        return entry;
    }

    private FileEntry() {
    }

    public FileEntry(String newSHA, String oldSHA, String file, String type) {
        this.newSHA = newSHA;
        this.oldSHA = oldSHA;
        this.file = file;
        this.type = DriftCategory.fromCode((String)type);
    }

    public String getFile() {
        return this.file;
    }

    public String getOldSHA() {
        return this.oldSHA;
    }

    public String getNewSHA() {
        return this.newSHA;
    }

    public DriftCategory getType() {
        return this.type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[newSHA: " + this.newSHA + ", oldSHA: " + this.oldSHA + ", file: " + this.file + ", type: " + this.type.code() + "]";
    }
}

