/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.content;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.DistributionFile;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.PackageVersionCriteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.DistributionManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.gui.content.ContentFilter;
import org.rhq.gui.content.EntitlementException;
import org.rhq.gui.content.HtmlRenderer;
import org.rhq.gui.content.YumMetadata;

public class ContentHTTPServlet
extends DefaultServlet {
    private static final long serialVersionUID = 1L;
    private final Log log = LogFactory.getLog(ContentHTTPServlet.class);
    protected static final String CONTENT_URI = "/content/";
    protected static final String PACKAGES = "packages";
    protected static final String DISTRIBUTIONS = "distributions";
    protected static final String REPODATA = "repodata";
    protected RepoManagerLocal repoMgr;
    protected ContentManagerLocal contentMgr;
    protected ContentSourceManagerLocal contentSourceMgr;
    protected DistributionManagerLocal distroMgr;
    protected URLCodec urlCodec;

    public void init() throws ServletException {
        super.init();
        this.urlCodec = new URLCodec();
        this.repoMgr = LookupUtil.getRepoManagerLocal();
        this.contentMgr = LookupUtil.getContentManager();
        this.contentSourceMgr = LookupUtil.getContentSourceManager();
        this.distroMgr = LookupUtil.getDistributionManagerLocal();
    }

    protected boolean isIconRequest(HttpServletRequest request) {
        String dir = this.getNthPiece(2, request.getRequestURI());
        return StringUtils.equalsIgnoreCase((String)dir, (String)"icons");
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.log.info((Object)("HEAD received: " + request.getRequestURI()));
        this.doGet(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.log.info((Object)("POST received: " + request.getRequestURI()));
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.log.info((Object)("PUT received: " + request.getRequestURI()));
        this.renderErrorPage(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.log.info((Object)("DELETE received: " + request.getRequestURI()));
        this.renderErrorPage(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.log.info((Object)("doGet():  requestURI = " + request.getRequestURI()));
        response.setHeader("Accept-Ranges", "bytes");
        if (this.isIconRequest(request)) {
            super.doGet(request, response);
            return;
        }
        Repo repo = this.getRepo(request, response);
        if (repo == null) {
            this.log.info((Object)"No repo found, possibly bad repo name, or no name was entered.");
            this.renderRepoList(request, response);
            return;
        }
        try {
            ContentFilter x509Filter = new ContentFilter();
            x509Filter.filter(request, repo.getId());
        }
        catch (EntitlementException e) {
            throw new ServletException((Throwable)e);
        }
        String typeOfContent = this.getTypeOfContent(request.getRequestURI());
        if (StringUtils.isBlank((String)typeOfContent)) {
            this.log.info((Object)"no info was specified for type of content.");
            this.renderChoiceOfContent(request, response, repo);
            return;
        }
        if (StringUtils.equalsIgnoreCase((String)typeOfContent, (String)PACKAGES)) {
            this.log.debug((Object)"render packages");
            this.renderPackages(request, response, repo);
            return;
        }
        if (StringUtils.equalsIgnoreCase((String)typeOfContent, (String)DISTRIBUTIONS)) {
            this.log.debug((Object)"render distributions");
            this.renderDistributions(request, response, repo);
            return;
        }
        this.log.debug((Object)("Unable to determine what type of content was requested: " + typeOfContent));
        this.renderErrorPage(request, response);
    }

    protected void renderRepoList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String repoName = this.getRepoName(request.getRequestURI());
        if (!StringUtils.isEmpty((String)repoName)) {
            this.log.info((Object)("Assuming bad repo name for: " + repoName + ", will render error page"));
            this.renderErrorPage(request, response);
            return;
        }
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        PageList repos = this.repoMgr.findRepos(overlord, PageControl.getUnlimitedInstance());
        this.log.debug((Object)("Returned list of repos: " + repos.getTotalSize() + " entries"));
        for (Repo r : repos) {
            this.log.debug((Object)("Potential repo: Name = " + r.getName() + ", ID = " + r.getId()));
        }
        this.log.debug((Object)"TODO: generate index.html");
        StringBuffer sb = new StringBuffer();
        HtmlRenderer.formStart((StringBuffer)sb, (String)"Index of ", (String)request.getRequestURI());
        for (Repo r : repos) {
            this.log.debug((Object)("Potential repo: Name = " + r.getName() + ", ID = " + r.getId()));
            if (r.isCandidate()) continue;
            String lastMod = new Date(r.getLastModifiedDate()).toString();
            HtmlRenderer.formDirEntry((StringBuffer)sb, (HttpServletRequest)request, (String)r.getName(), (String)lastMod);
        }
        HtmlRenderer.formEnd((StringBuffer)sb);
        this.writeResponse(sb.toString(), response);
    }

    protected void renderChoiceOfContent(HttpServletRequest request, HttpServletResponse response, Repo repo) throws IOException {
        StringBuffer sb = new StringBuffer();
        HtmlRenderer.formStart((StringBuffer)sb, (String)"Index of ", (String)request.getRequestURI());
        HtmlRenderer.formParentLink((StringBuffer)sb, (String)this.getParentURI(request.getRequestURI()));
        HtmlRenderer.formDirEntry((StringBuffer)sb, (HttpServletRequest)request, (String)PACKAGES, (String)"-");
        HtmlRenderer.formDirEntry((StringBuffer)sb, (HttpServletRequest)request, (String)DISTRIBUTIONS, (String)"-");
        HtmlRenderer.formEnd((StringBuffer)sb);
        this.writeResponse(sb.toString(), response);
    }

    protected void renderPackages(HttpServletRequest request, HttpServletResponse response, Repo repo) throws IOException {
        this.log.debug((Object)("renderPackages(repo name = " + repo.getName() + ", id = " + repo.getId() + ", isCandidate = " + repo.isCandidate() + ")"));
        String fileName = this.getFileName(request.getRequestURI());
        this.log.debug((Object)("Parsed file name = " + fileName));
        if (StringUtils.isBlank((String)fileName)) {
            this.log.debug((Object)("create listing of all packages for this repo: " + repo.getName()));
            this.renderPackageIndex(request, response, repo);
            return;
        }
        if (StringUtils.equals((String)fileName, (String)REPODATA)) {
            this.renderMetadata(request, response, repo);
            return;
        }
        this.log.debug((Object)"fetch package bits and return them.");
        PackageVersion pv = this.getPackageVersionFromFileName(repo, fileName);
        if (pv == null) {
            this.log.info((Object)("Unable to find PackageVersion from filename: " + fileName));
            this.renderErrorPage(request, response);
            return;
        }
        this.writePackageVersionBits(request, response, pv);
    }

    protected void renderPackageIndex(HttpServletRequest request, HttpServletResponse response, Repo repo) throws IOException {
        this.log.debug((Object)("Forming packages index.html for repo: " + repo.getName() + ", ID = " + repo.getId()));
        PageList pvs = this.repoMgr.findPackageVersionsInRepo(LookupUtil.getSubjectManager().getOverlord(), repo.getId(), PageControl.getUnlimitedInstance());
        StringBuffer sb = new StringBuffer();
        HtmlRenderer.formStart((StringBuffer)sb, (String)"Index of ", (String)request.getRequestURI());
        HtmlRenderer.formParentLink((StringBuffer)sb, (String)this.getParentURI(request.getRequestURI()));
        for (PackageVersion pv : pvs) {
            HtmlRenderer.formFileEntry((StringBuffer)sb, (HttpServletRequest)request, (String)pv.getFileName(), (String)new Date(pv.getFileCreatedDate()).toString(), (long)pv.getFileSize());
        }
        HtmlRenderer.formEnd((StringBuffer)sb);
        this.writeResponse(sb.toString(), response);
    }

    protected void renderMetadata(HttpServletRequest request, HttpServletResponse response, Repo repo) throws IOException {
        this.log.debug((Object)("renderMetadata(repo name = " + repo.getName() + ", id = " + repo.getId()));
        String metadataFilename = this.getMetadataFileName(request.getRequestURI());
        if (StringUtils.isBlank((String)metadataFilename)) {
            this.renderMetadataIndex(request, response, repo);
            return;
        }
        this.log.debug((Object)("Generate Yum Metadata for : " + metadataFilename));
        PageList pvs = this.repoMgr.findPackageVersionsInRepo(LookupUtil.getSubjectManager().getOverlord(), repo.getId(), PageControl.getUnlimitedInstance());
        this.log.debug((Object)(pvs.size() + " packages were found for repo : " + repo.getName()));
        StringBuffer sb = new StringBuffer();
        if (!YumMetadata.generate((StringBuffer)sb, (Repo)repo, (List)pvs, (String)metadataFilename)) {
            this.log.info((Object)("Error generating: " + metadataFilename + " for repo: " + repo.getName() + " with " + pvs.size() + " packages"));
            this.renderErrorPage(request, response);
            return;
        }
        this.writeResponse(sb.toString(), response, "text/xml; charset=utf-8");
    }

    protected void renderMetadataIndex(HttpServletRequest request, HttpServletResponse response, Repo repo) throws IOException {
        this.log.debug((Object)("renderMetadataIndex(repo name = " + repo.getName() + ", id = " + repo.getId()));
        StringBuffer sb = new StringBuffer();
        HtmlRenderer.formStart((StringBuffer)sb, (String)"Index of ", (String)request.getRequestURI());
        HtmlRenderer.formParentLink((StringBuffer)sb, (String)this.getParentURI(request.getRequestURI()));
        HtmlRenderer.formFileEntry((StringBuffer)sb, (HttpServletRequest)request, (String)"primary.xml", (String)new Date().toString(), (long)-1L);
        HtmlRenderer.formFileEntry((StringBuffer)sb, (HttpServletRequest)request, (String)"repomd.xml", (String)new Date().toString(), (long)-1L);
        HtmlRenderer.formEnd((StringBuffer)sb);
        this.writeResponse(sb.toString(), response);
    }

    protected void renderDistributions(HttpServletRequest request, HttpServletResponse response, Repo repo) throws IOException {
        this.log.debug((Object)("renderDistributions(repo name = " + repo.getName() + ", id = " + repo.getId() + ", isCandidate = " + repo.isCandidate() + ")"));
        String distLabel = this.getDistLabel(request.getRequestURI());
        this.log.debug((Object)("Parsed dist label is = " + distLabel));
        if (StringUtils.isBlank((String)distLabel)) {
            this.log.info((Object)("TODO: create index.html listing all the distribution labels for this repo: " + repo.getName()));
            this.renderDistributionLabels(request, response, repo);
            return;
        }
        Distribution dist = this.distroMgr.getDistributionByLabel(distLabel);
        if (dist == null) {
            this.log.info((Object)("Unable to find Distribution by label '" + distLabel + "'"));
            this.renderErrorPage(request, response);
            return;
        }
        String fileRequest = this.getDistFilePath(request.getRequestURI());
        if (StringUtils.isEmpty((String)fileRequest)) {
            this.log.info((Object)"no distribution file was found in request, so render list of all distribution files");
            this.renderDistributionFileList(request, response, dist);
            return;
        }
        this.log.debug((Object)("Parsed DistributionFile request is for: " + fileRequest));
        List distFiles = this.distroMgr.getDistributionFilesByDistId(dist.getId());
        if (distFiles.isEmpty()) {
            this.log.info((Object)("Unable to find any distribution files for dist: " + dist.getLabel()));
            this.renderErrorPage(request, response);
            return;
        }
        for (DistributionFile dFile : distFiles) {
            if (!StringUtils.equalsIgnoreCase((String)dFile.getRelativeFilename(), (String)fileRequest)) continue;
            this.log.info((Object)("Sending back package bytes for: " + dFile.getRelativeFilename()));
            this.writeDistributionFileBits(request, response, dFile);
            return;
        }
        String possiblePkgName = this.getLastPiece(request.getRequestURI());
        this.log.debug((Object)("Looking up : " + possiblePkgName + ", it might be a package request"));
        PackageVersion pv = this.getPackageVersionFromFileName(repo, possiblePkgName);
        if (pv != null) {
            this.log.info((Object)(possiblePkgName + " resolved to a package, will send package bytes back as response"));
            this.writePackageVersionBits(request, response, pv);
            return;
        }
        this.log.info((Object)("Searched through DistributionFiles and Packages, unable to find: " + fileRequest + ", in Distribution: " + dist.getLabel()));
        this.renderErrorPage(request, response);
    }

    protected void renderDistributionFileList(HttpServletRequest request, HttpServletResponse response, Distribution dist) throws IOException {
        List distFiles = this.distroMgr.getDistributionFilesByDistId(dist.getId());
        this.log.debug((Object)("For Distribution label '" + dist.getLabel() + "' " + distFiles.size() + " distribution files were found"));
        StringBuffer sb = new StringBuffer();
        HtmlRenderer.formStart((StringBuffer)sb, (String)"Index of ", (String)request.getRequestURI());
        HtmlRenderer.formParentLink((StringBuffer)sb, (String)this.getParentURI(request.getRequestURI()));
        for (DistributionFile dFile : distFiles) {
            HtmlRenderer.formFileEntry((StringBuffer)sb, (HttpServletRequest)request, (String)dFile.getRelativeFilename(), (String)new Date(dFile.getLastModified()).toString(), (long)-1L);
        }
        HtmlRenderer.formEnd((StringBuffer)sb);
        this.writeResponse(sb.toString(), response);
    }

    protected void renderDistributionLabels(HttpServletRequest request, HttpServletResponse response, Repo repo) throws IOException {
        StringBuffer sb = new StringBuffer();
        HtmlRenderer.formStart((StringBuffer)sb, (String)"Index of ", (String)request.getRequestURI());
        HtmlRenderer.formParentLink((StringBuffer)sb, (String)this.getParentURI(request.getRequestURI()));
        PageList distros = this.repoMgr.findAssociatedDistributions(LookupUtil.getSubjectManager().getOverlord(), repo.getId(), PageControl.getUnlimitedInstance());
        this.log.debug((Object)("Found " + distros.size() + " for repo " + repo.getName()));
        for (Distribution d : distros) {
            this.log.info((Object)("Creating link for distribution label: " + d.getLabel()));
            HtmlRenderer.formDirEntry((StringBuffer)sb, (HttpServletRequest)request, (String)d.getLabel(), (String)new Date(d.getLastModifiedDate()).toString());
        }
        HtmlRenderer.formEnd((StringBuffer)sb);
        this.writeResponse(sb.toString(), response);
    }

    protected void renderErrorPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.log.info((Object)("render error page for request: " + request.getRequestURI()));
        response.sendError(404);
    }

    protected boolean writeResponse(String data, HttpServletResponse response) throws IOException {
        return this.writeResponse(data, response, "text/html");
    }

    protected boolean writeResponse(String data, HttpServletResponse response, String contentType) throws IOException {
        response.setContentType(contentType);
        PrintWriter out = response.getWriter();
        out.write(data);
        out.flush();
        out.close();
        return true;
    }

    protected Repo getRepo(HttpServletRequest request, HttpServletResponse response) {
        String repoName = this.getRepoName(request.getRequestURI());
        this.log.debug((Object)("Parsed repo name = " + repoName));
        List targetRepos = this.repoMgr.getRepoByName(repoName);
        if (targetRepos.isEmpty()) {
            try {
                Integer repoId = Integer.parseInt(repoName);
                return this.repoMgr.getRepo(LookupUtil.getSubjectManager().getOverlord(), repoId.intValue());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return (Repo)targetRepos.get(0);
    }

    protected String getRepoName(String requestURI) {
        return this.getNthPiece(2, requestURI);
    }

    protected String getTypeOfContent(String requestURI) {
        return this.getNthPiece(3, requestURI);
    }

    protected String getFileName(String requestURI) {
        return this.getNthPiece(4, requestURI);
    }

    protected String getMetadataFileName(String requestURI) {
        return this.getNthPiece(5, requestURI);
    }

    protected String getDistLabel(String requestURI) {
        return this.getNthPiece(4, requestURI);
    }

    protected String getLastPiece(String requestURI) {
        StrTokenizer st = new StrTokenizer(this.decodeURL(requestURI), "/");
        List tokens = st.getTokenList();
        if (tokens.size() < 1) {
            return "";
        }
        return (String)tokens.get(tokens.size() - 1);
    }

    protected String getDistFilePath(String requestURI) {
        StrTokenizer st = new StrTokenizer(this.decodeURL(requestURI), "/");
        List tokens = st.getTokenList();
        if (tokens.isEmpty()) {
            return "";
        }
        int startIndex = 4;
        String distFilePath = "";
        for (int index = startIndex; index < tokens.size(); ++index) {
            distFilePath = distFilePath + "/" + (String)tokens.get(index);
            this.log.debug((Object)("index = " + index + ", distFilePath = " + distFilePath));
        }
        if (distFilePath.startsWith("/")) {
            distFilePath = distFilePath.substring(1);
        }
        return distFilePath;
    }

    protected String getNthPiece(int n, String requestURI) {
        StrTokenizer st = new StrTokenizer(this.decodeURL(requestURI), "/");
        List tokens = st.getTokenList();
        if (tokens.size() < n) {
            return "";
        }
        return (String)tokens.get(n - 1);
    }

    protected String getParentURI(String uri) {
        int index;
        if ((uri = this.decodeURL(uri)).endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if ((index = uri.lastIndexOf("/")) == -1) {
            return uri;
        }
        return uri.substring(0, index);
    }

    protected String decodeURL(String requestURI) {
        String req = null;
        try {
            req = this.urlCodec.decode(requestURI);
        }
        catch (DecoderException e) {
            this.log.info((Object)e);
            return "";
        }
        return req;
    }

    protected PackageVersion getPackageVersionFromFileName(Repo repo, String fileName) {
        PackageVersionCriteria criteria = new PackageVersionCriteria();
        criteria.addFilterFileName(fileName);
        criteria.addFilterRepoId(Integer.valueOf(repo.getId()));
        criteria.setStrict(true);
        this.log.debug((Object)("Created criteria for repoId = " + repo.getId() + ", fileName = " + fileName));
        PageList pkgVers = this.contentMgr.findPackageVersionsByCriteria(LookupUtil.getSubjectManager().getOverlord(), criteria);
        for (PackageVersion pkgV : pkgVers) {
            this.log.debug((Object)("PackageVersion found: " + pkgV));
        }
        this.log.debug((Object)("Found " + pkgVers.size() + " entries"));
        PackageVersion pv = null;
        if (pkgVers.size() > 0) {
            pv = (PackageVersion)pkgVers.get(0);
        } else {
            this.log.info((Object)("Couldn't find " + fileName + " in " + repo.getName()));
        }
        return pv;
    }

    protected boolean writeDistributionFileBits(HttpServletRequest request, HttpServletResponse response, DistributionFile distFile) throws IOException {
        try {
            ServletOutputStream output = response.getOutputStream();
            response.setContentType("application/octet-stream");
            this.contentSourceMgr.outputDistributionFileBits(distFile, (OutputStream)output);
            output.flush();
            output.close();
        }
        catch (IllegalStateException e) {
            this.log.error((Object)e);
            return false;
        }
        catch (IOException e) {
            this.log.error((Object)e);
            return false;
        }
        return true;
    }

    protected boolean writePackageVersionBits(HttpServletRequest request, HttpServletResponse response, PackageVersion pkgVer) {
        long startRange = this.getStartRange(request);
        long endRange = this.getEndRange(request);
        if (endRange < 0L) {
            response.setContentType("application/x-rpm");
            response.setContentLength(pkgVer.getFileSize().intValue());
        } else {
            response.setContentType("application/octet-stream");
            this.log.debug((Object)("Range request: start = " + startRange + ", end = " + endRange));
            int contentLength = new Long(endRange).intValue() - new Long(startRange).intValue() + 1;
            this.log.debug((Object)("Setting contentLength = " + contentLength));
            response.setContentLength(contentLength);
            response.setStatus(206);
            String rangeHdr = "bytes=" + startRange + "-" + endRange + "/" + contentLength;
            response.setHeader("Content-Range", rangeHdr);
        }
        try {
            ServletOutputStream output = response.getOutputStream();
            this.contentSourceMgr.outputPackageVersionBits(pkgVer, (OutputStream)output, startRange, endRange);
            output.flush();
            output.close();
        }
        catch (IllegalStateException e) {
            this.log.error((Object)e);
            return false;
        }
        catch (IOException e) {
            this.log.error((Object)e);
            return false;
        }
        return true;
    }

    protected String[] getRanges(HttpServletRequest request) {
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        String[] ranges = rangeHeader.split("=");
        if (ranges.length < 2) {
            return null;
        }
        String[] indexes = ranges[1].split("-");
        if (indexes.length < 2) {
            return null;
        }
        return indexes;
    }

    protected long getStartRange(HttpServletRequest request) {
        String[] indexes = this.getRanges(request);
        if (indexes == null || indexes.length < 2) {
            return 0L;
        }
        return Long.valueOf(indexes[0]);
    }

    protected long getEndRange(HttpServletRequest request) {
        String[] indexes = this.getRanges(request);
        if (indexes == null || indexes.length < 2) {
            return -1L;
        }
        return Long.valueOf(indexes[1]);
    }
}

