/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.server.metrics.AbortedException;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.SignalingCountDownLatch;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.aggregation.AggregationState;
import org.rhq.server.metrics.aggregation.Compute1HourData;
import org.rhq.server.metrics.aggregation.Compute24HourData;
import org.rhq.server.metrics.aggregation.Compute6HourData;
import org.rhq.server.metrics.aggregation.OneHourDataScheduler;
import org.rhq.server.metrics.aggregation.RawDataScheduler;
import org.rhq.server.metrics.aggregation.SixHourDataScheduler;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.MetricsTable;

public class Aggregator {
    private static final Comparator<AggregateNumericMetric> AGGREGATE_COMPARATOR = new Comparator<AggregateNumericMetric>(){

        @Override
        public int compare(AggregateNumericMetric left, AggregateNumericMetric right) {
            return left.getScheduleId() < right.getScheduleId() ? -1 : (left.getScheduleId() == right.getScheduleId() ? 0 : 1);
        }
    };
    private final Log log = LogFactory.getLog(Aggregator.class);
    private MetricsDAO dao;
    private MetricsConfiguration configuration;
    private DateTimeService dtService;
    private DateTime startTime;
    private AggregationState state;
    private Set<AggregateNumericMetric> oneHourData;

    public Aggregator(ListeningExecutorService aggregationTasks, MetricsDAO dao, MetricsConfiguration configuration, DateTimeService dtService, DateTime startTime, int batchSize, int parallelism) {
        this.dao = dao;
        this.configuration = configuration;
        this.dtService = dtService;
        this.startTime = startTime;
        this.oneHourData = new ConcurrentSkipListSet<AggregateNumericMetric>(AGGREGATE_COMPARATOR);
        DateTime sixHourTimeSlice = this.get6HourTimeSlice();
        DateTime twentyFourHourTimeSlice = this.get24HourTimeSlice();
        this.state = new AggregationState().setDao(dao).setStartTime(startTime).setBatchSize(batchSize).setAggregationTasks(aggregationTasks).setPermits(new Semaphore(parallelism * batchSize, true)).setRawAggregationDone(new SignalingCountDownLatch(new CountDownLatch(1))).setOneHourAggregationDone(new SignalingCountDownLatch(new CountDownLatch(1))).setSixHourAggregationDone(new SignalingCountDownLatch(new CountDownLatch(1))).setOneHourTimeSlice(startTime).setOneHourTimeSliceEnd(startTime.plus((ReadableDuration)configuration.getRawTimeSliceDuration())).setSixHourTimeSlice(sixHourTimeSlice).setSixHourTimeSliceEnd(sixHourTimeSlice.plus((ReadableDuration)configuration.getOneHourTimeSliceDuration())).setTwentyFourHourTimeSlice(twentyFourHourTimeSlice).setTwentyFourHourTimeSliceEnd(twentyFourHourTimeSlice.plus((ReadableDuration)configuration.getSixHourTimeSliceDuration())).setCompute1HourData(new Compute1HourData(startTime, sixHourTimeSlice, dao, this.oneHourData)).setCompute6HourData(new Compute6HourData(sixHourTimeSlice, twentyFourHourTimeSlice, dao)).setCompute24HourData(new Compute24HourData(twentyFourHourTimeSlice, dao)).set6HourTimeSliceFinished(this.hasTimeSliceEnded(sixHourTimeSlice, configuration.getOneHourTimeSliceDuration())).set24HourTimeSliceFinished(this.hasTimeSliceEnded(twentyFourHourTimeSlice, configuration.getSixHourTimeSliceDuration())).setRemainingRawData(new AtomicInteger(0)).setRemaining1HourData(new AtomicInteger(0)).setRemaining6HourData(new AtomicInteger(0));
    }

    private DateTime get24HourTimeSlice() {
        return this.dtService.getTimeSlice(this.startTime, this.configuration.getSixHourTimeSliceDuration());
    }

    private DateTime get6HourTimeSlice() {
        return this.dtService.getTimeSlice(this.startTime, this.configuration.getOneHourTimeSliceDuration());
    }

    private boolean hasTimeSliceEnded(DateTime startTime, Duration duration) {
        DateTime endTime = startTime.plus((ReadableDuration)duration);
        return DateTimeComparator.getInstance().compare((Object)this.currentHour(), (Object)endTime) >= 0;
    }

    protected DateTime currentHour() {
        return this.dtService.getTimeSlice(this.dtService.now(), this.configuration.getRawTimeSliceDuration());
    }

    public Set<AggregateNumericMetric> run() {
        this.log.info((Object)("Starting aggregation for time slice " + this.startTime));
        try {
            Stopwatch stopwatch = new Stopwatch().start();
            ArrayList<MetricsTable> indexUpdates = new ArrayList<MetricsTable>(3);
            indexUpdates.add(MetricsTable.ONE_HOUR);
            StorageResultSetFuture rawIndexFuture = this.dao.findMetricsIndexEntriesAsync(MetricsTable.ONE_HOUR, this.startTime.getMillis());
            Futures.addCallback((ListenableFuture)rawIndexFuture, (FutureCallback)new RawDataScheduler(this.state), (Executor)this.state.getAggregationTasks());
            this.state.getRawAggregationDone().await();
            stopwatch.stop();
            this.log.info((Object)("Finished aggregating raw data in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            if (this.state.is6HourTimeSliceFinished()) {
                this.log.info((Object)"Starting aggregation of 1 hour data");
                stopwatch.reset().start();
                indexUpdates.add(MetricsTable.SIX_HOUR);
                StorageResultSetFuture oneHourIndexFuture = this.dao.findMetricsIndexEntriesAsync(MetricsTable.SIX_HOUR, this.state.getSixHourTimeSlice().getMillis());
                Futures.addCallback((ListenableFuture)oneHourIndexFuture, (FutureCallback)new OneHourDataScheduler(this.state), (Executor)this.state.getAggregationTasks());
                this.state.getOneHourAggregationDone().await();
                stopwatch.stop();
                this.log.info((Object)("Finished aggregating one hour data in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
            if (this.state.is24HourTimeSliceFinished()) {
                this.log.info((Object)"Starting aggregation of 6 hour data");
                stopwatch.reset().start();
                indexUpdates.add(MetricsTable.TWENTY_FOUR_HOUR);
                StorageResultSetFuture sixHourIndexFuture = this.dao.findMetricsIndexEntriesAsync(MetricsTable.TWENTY_FOUR_HOUR, this.state.getTwentyFourHourTimeSlice().getMillis());
                Futures.addCallback((ListenableFuture)sixHourIndexFuture, (FutureCallback)new SixHourDataScheduler(this.state), (Executor)this.state.getAggregationTasks());
                this.state.getSixHourAggregationDone().await();
                stopwatch.stop();
                this.log.info((Object)("Finished aggregating six hour data in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
            }
            CountDownLatch updateIndexSignal = new CountDownLatch(indexUpdates.size());
            for (MetricsTable table : indexUpdates) {
                this.deleteIndexEntries(table, updateIndexSignal);
            }
            updateIndexSignal.await();
            return this.oneHourData;
        }
        catch (InterruptedException e) {
            this.log.info((Object)"There was an interrupt while waiting for aggregation to finish. Aggregation will be aborted.");
            return Collections.emptySet();
        }
        catch (AbortedException e) {
            this.log.warn((Object)("Aggregation has been aborted: " + e.getMessage()));
            return Collections.emptySet();
        }
    }

    private void deleteIndexEntries(final MetricsTable table, final CountDownLatch doneSignal) {
        DateTime time;
        switch (table) {
            case ONE_HOUR: {
                time = this.startTime;
                break;
            }
            case SIX_HOUR: {
                time = this.state.getSixHourTimeSlice();
                break;
            }
            default: {
                time = this.state.getTwentyFourHourTimeSlice();
            }
        }
        this.log.debug((Object)("Deleting " + (Object)((Object)table) + " index entries for time slice " + time));
        StorageResultSetFuture future = this.dao.deleteMetricsIndexEntriesAsync(table, time.getMillis());
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ResultSet>(){

            public void onSuccess(ResultSet result) {
                doneSignal.countDown();
            }

            public void onFailure(Throwable t) {
                if (Aggregator.this.log.isDebugEnabled()) {
                    Aggregator.this.log.debug((Object)("Failed to delete index entries for table " + (Object)((Object)table) + " at time [" + time + "]. An " + "unexpected error occurred."), t);
                } else {
                    Aggregator.this.log.warn((Object)("Failed to delete index entries for table " + (Object)((Object)table) + " at time [" + time + "]. An " + "unexpected error occurred: " + ThrowableUtil.getRootMessage((Throwable)t)));
                }
                doneSignal.countDown();
            }
        });
    }
}

