/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.server.metrics.aggregation.BatchAggregationState;

class BatchAggregator
implements Runnable {
    private final Log log = LogFactory.getLog(BatchAggregator.class);
    private BatchAggregationState state;

    public BatchAggregator(BatchAggregationState state) {
        this.state = state;
    }

    @Override
    public void run() {
        ListenableFuture queriesFuture = Futures.successfulAsList(this.state.getQueryFutures());
        ListenableFuture insertFutures = Futures.transform((ListenableFuture)queriesFuture, this.state.getComputeAggregates(), (Executor)this.state.getAggregationTasks());
        Futures.addCallback((ListenableFuture)insertFutures, (FutureCallback)new FutureCallback<List<ResultSet>>(){

            public void onSuccess(List<ResultSet> result) {
                BatchAggregator.this.updateRemainingSchedules();
                BatchAggregator.this.state.getStopwatch().stop();
                if (BatchAggregator.this.log.isDebugEnabled()) {
                    BatchAggregator.this.log.debug((Object)("Finished aggregating " + (Object)((Object)BatchAggregator.this.state.getAggregationType()) + " for " + BatchAggregator.this.state.getQueryFutures().size() + " schedules in " + BatchAggregator.this.state.getStopwatch().elapsed(TimeUnit.MILLISECONDS) + " ms"));
                }
                BatchAggregator.this.state.getPermits().release(BatchAggregator.this.state.getQueryFutures().size());
            }

            public void onFailure(Throwable t) {
                if (BatchAggregator.this.log.isDebugEnabled()) {
                    BatchAggregator.this.log.debug((Object)("There was an error during " + (Object)((Object)BatchAggregator.this.state.getAggregationType()) + " aggregation"), ThrowableUtil.getRootCause((Throwable)t));
                } else {
                    BatchAggregator.this.log.warn((Object)("There was an error during " + (Object)((Object)BatchAggregator.this.state.getAggregationType()) + " aggregation: " + ThrowableUtil.getRootMessage((Throwable)t)));
                }
                BatchAggregator.this.state.getPermits().release(BatchAggregator.this.state.getQueryFutures().size());
                BatchAggregator.this.updateRemainingSchedules();
            }
        }, (Executor)this.state.getAggregationTasks());
    }

    private void updateRemainingSchedules() {
        int count = this.state.getRemainingSchedules().addAndGet(-this.state.getQueryFutures().size());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("There are " + count + " remaining schedules with " + (Object)((Object)this.state.getAggregationType()) + " to be aggregated"));
        }
        if (count == 0) {
            this.state.getDoneSignal().countDown();
        } else if (count < 0) {
            this.log.warn((Object)"The number of remaining schedules should never be less that zero. ");
            this.state.getDoneSignal().abort("There are " + count + " remaining schedules with " + (Object)((Object)this.state.getAggregationType()) + " to be aggregated. The count should never be less than zero.");
        }
    }
}

