/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.obfuscation;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public final class Obfuscator {
    private static final byte[] KEY = "jaas is the way".getBytes();
    public static final String ALGORITHM = "Blowfish";

    private Obfuscator() {
    }

    public static String encode(String secret) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        SecretKeySpec key = new SecretKeySpec(KEY, ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, key);
        byte[] encoding = cipher.doFinal(secret.getBytes());
        BigInteger n = new BigInteger(encoding);
        return n.toString(16);
    }

    public static String decode(String secret) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        SecretKeySpec key = new SecretKeySpec(KEY, ALGORITHM);
        BigInteger n = new BigInteger(secret, 16);
        byte[] encoding = n.toByteArray();
        if (encoding.length % 8 != 0) {
            int i;
            int length = encoding.length;
            int newLength = (length / 8 + 1) * 8;
            int pad = newLength - length;
            byte[] old = encoding;
            encoding = new byte[newLength];
            for (i = old.length - 1; i >= 0; --i) {
                encoding[i + pad] = old[i];
            }
            if (n.signum() == -1) {
                for (i = 0; i < newLength - length; ++i) {
                    encoding[i] = -1;
                }
            }
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, key);
        byte[] decode = cipher.doFinal(encoding);
        return new String(decode);
    }

    public static String generateString(Random random, String validCharacters, int length) {
        validCharacters = null == validCharacters || validCharacters.isEmpty() ? "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ" : validCharacters;
        length = length < 1 ? 10 : length;
        char[] text = new char[length];
        for (int i = 0; i < length; ++i) {
            text[i] = validCharacters.charAt(random.nextInt(validCharacters.length()));
        }
        return new String(text);
    }
}

