/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator.datasources;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.server.metrics.migrator.datasources.ExistingDataSource;

public abstract class ExistingDataBulkExportSource
implements ExistingDataSource {
    private static final Log log = LogFactory.getLog(ExistingDataBulkExportSource.class);
    protected static final int IO_BUFFER_SIZE = 65536;
    protected static final String DELIMITER = "|";
    private File existingDataFile;
    private BufferedReader existingDataFileReader;
    private int currentIndex;

    public ExistingDataBulkExportSource() {
        Random random = new Random();
        String exportFileName = System.currentTimeMillis() + "." + random.nextInt() + ".export";
        this.existingDataFile = new File(System.getProperty("java.io.tmpdir"), exportFileName);
    }

    @Override
    public void initialize() throws Exception {
        this.exportExistingData();
        this.startReading();
    }

    @Override
    public void close() throws Exception {
        this.stopReading();
        this.removeTempFile();
    }

    protected abstract void exportExistingData() throws Exception;

    protected File getExistingDataFile() {
        return this.existingDataFile;
    }

    protected void startReading() throws Exception {
        if (!(this.existingDataFile.exists() || this.existingDataFile.isFile() || this.existingDataFile.canRead())) {
            throw new IllegalStateException();
        }
        this.existingDataFileReader = new BufferedReader(new FileReader(this.existingDataFile));
        this.currentIndex = 0;
    }

    protected void stopReading() {
        StreamUtil.safeClose((Closeable)this.existingDataFileReader);
    }

    protected void removeTempFile() {
        if (this.existingDataFile.exists()) {
            try {
                this.existingDataFile.delete();
            }
            catch (Exception e) {
                log.debug((Object)("Unable to clean temporary file " + this.existingDataFile), (Throwable)e);
            }
        }
    }

    @Override
    public List<Object[]> getData(int fromIndex, int maxResults) throws Exception {
        String nextLine;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading lines " + fromIndex + " to " + (fromIndex + maxResults)));
        }
        if (fromIndex != this.currentIndex) {
            throw new IllegalStateException();
        }
        LinkedList<Object[]> results = new LinkedList<Object[]>();
        for (int i = 0; i < maxResults && (nextLine = this.existingDataFileReader.readLine()) != null; ++i) {
            ++this.currentIndex;
            StringTokenizer stringTokenizer = new StringTokenizer(nextLine, DELIMITER);
            Object[] row = new Object[stringTokenizer.countTokens()];
            for (int j = 0; j < row.length; ++j) {
                row[j] = stringTokenizer.nextToken();
            }
            results.add(row);
        }
        return results;
    }
}

