/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator.datasources;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.server.metrics.migrator.datasources.ExistingDataBulkExportSource;

public class ExistingDataJPABulkExportSource
extends ExistingDataBulkExportSource {
    private EntityManager entityManager;
    private String selectNativeQuery;

    public ExistingDataJPABulkExportSource(EntityManager entityManager, String selectNativeQuery) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportExistingData() throws Exception {
        BufferedWriter fileWriter = null;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            fileWriter = new BufferedWriter(new FileWriter(this.getExistingDataFile()), 65536);
            Session session = (Session)this.entityManager.getDelegate();
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)session.getSessionFactory();
            ConnectionProvider cp = sfi.getConnectionProvider();
            connection = cp.getConnection();
            statement = connection.prepareStatement(this.selectNativeQuery);
            resultSet = statement.executeQuery();
            int columnCount = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                for (int i = 1; i < columnCount + 1; ++i) {
                    if (i > 1) {
                        fileWriter.write("|");
                    }
                    fileWriter.write(resultSet.getString(i));
                }
                fileWriter.write("\n");
            }
        }
        catch (Throwable throwable) {
            StreamUtil.safeClose(fileWriter);
            JDBCUtil.safeClose(connection, statement, resultSet);
            throw throwable;
        }
        StreamUtil.safeClose((Closeable)fileWriter);
        JDBCUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
    }
}

