/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.updater.ChangesFileHashcodeMap;

public class FileHashcodeMap
extends TreeMap<String, String> {
    public static final String UNKNOWN_DIR_HASHCODE = "?UNKNOWN_DIR_HASHCODE?";
    public static final String UNKNOWN_FILE_HASHCODE = "?UNKNOWN_FILE_HASHCODE?";
    public static final String DELETED_FILE_HASHCODE = "?DELETED_FILE_HASHCODE?";
    public static final String DIRECTORY_HASHCODE = "?DIRECTORY?";
    private static final long serialVersionUID = 1L;
    private static final String COLUMN_SEPARATOR = "\t";

    public static FileHashcodeMap generateFileHashcodeMap(File rootDir, Pattern ignoreRegex, Set<String> ignored) throws Exception {
        if (ignored == null) {
            ignored = new HashSet<String>();
        } else {
            ignored.clear();
        }
        FileHashcodeMap map = new FileHashcodeMap();
        FileHashcodeMap.generateFileHashcodeMapRecursive(map, rootDir.getAbsolutePath(), 0, rootDir, ignoreRegex, ignored);
        return map;
    }

    private static void generateFileHashcodeMapRecursive(FileHashcodeMap map, String rootPath, int level, File fileOrDir, Pattern ignoreRegex, Set<String> ignored) throws Exception {
        if (fileOrDir == null || !fileOrDir.exists()) {
            throw new Exception("Non-existent file/directory provided: " + fileOrDir);
        }
        String path = level == 0 ? fileOrDir.getName() : fileOrDir.getAbsolutePath().substring(rootPath.length() + 1);
        if (ignoreRegex != null && ignoreRegex.matcher(path).matches()) {
            ignored.add(path);
            return;
        }
        if (fileOrDir.isDirectory()) {
            if (fileOrDir.getName().equals(".rhqdeployments")) {
                return;
            }
            File[] children = fileOrDir.listFiles();
            if (children != null) {
                for (File child : children) {
                    FileHashcodeMap.generateFileHashcodeMapRecursive(map, rootPath, level + 1, child, ignoreRegex, ignored);
                }
            } else {
                map.put(path, UNKNOWN_DIR_HASHCODE);
            }
        } else {
            String hashcode;
            try {
                hashcode = MessageDigestGenerator.getDigestString(fileOrDir);
            }
            catch (Exception e) {
                hashcode = UNKNOWN_FILE_HASHCODE;
            }
            map.put(path, hashcode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileHashcodeMap loadFromFile(File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            FileHashcodeMap map = new FileHashcodeMap();
            int lineNumber = 1;
            String line = reader.readLine();
            while (line != null) {
                String[] columns = line.split(COLUMN_SEPARATOR);
                if (columns.length != 2) {
                    throw new Exception("Format error in [" + file.getAbsolutePath() + "] at line #[" + lineNumber + "]: " + line);
                }
                map.put(columns[0], columns[1]);
                ++lineNumber;
                line = reader.readLine();
            }
            FileHashcodeMap fileHashcodeMap = map;
            return fileHashcodeMap;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeToFile(File file) throws Exception {
        PrintWriter writer = new PrintWriter(file);
        try {
            for (Map.Entry entry : this.entrySet()) {
                writer.println((String)entry.getKey() + COLUMN_SEPARATOR + (String)entry.getValue());
            }
        }
        finally {
            writer.close();
        }
    }

    public ChangesFileHashcodeMap rescan(File rootDir, Pattern ignoreRegex, boolean reportNewRootFilesAsNew) throws Exception {
        ChangesFileHashcodeMap current = new ChangesFileHashcodeMap(this);
        for (Map.Entry entry : this.entrySet()) {
            String originalFileString = (String)entry.getKey();
            if (ignoreRegex != null && ignoreRegex.matcher(originalFileString).matches()) {
                current.remove(originalFileString);
                current.getIgnored().add(originalFileString);
                continue;
            }
            File originalFile = new File(originalFileString);
            if (!originalFile.isAbsolute()) {
                originalFile = new File(rootDir, originalFileString);
            }
            if (originalFile.exists()) {
                String currentHashcode = DIRECTORY_HASHCODE;
                if (!originalFile.isDirectory()) {
                    currentHashcode = MessageDigestGenerator.getDigestString(originalFile);
                }
                current.put(originalFileString, currentHashcode);
                String originalHashcode = (String)entry.getValue();
                if (currentHashcode.equals(originalHashcode)) continue;
                current.getChanges().put(originalFileString, currentHashcode);
                continue;
            }
            current.put(originalFileString, DELETED_FILE_HASHCODE);
            current.getDeletions().put(originalFileString, DELETED_FILE_HASHCODE);
        }
        FileHashcodeMap newFiles = new FileHashcodeMap();
        HashSet<String> skippedFiles = new HashSet<String>();
        this.lookForNewFilesRecursive(newFiles, skippedFiles, rootDir.getAbsolutePath(), 0, rootDir, ignoreRegex, current.getIgnored(), reportNewRootFilesAsNew);
        current.putAll(newFiles);
        current.getAdditions().putAll(newFiles);
        current.getSkipped().addAll(skippedFiles);
        return current;
    }

    private void lookForNewFilesRecursive(FileHashcodeMap newFiles, Set<String> skippedFiles, String rootPath, int level, File fileOrDir, Pattern ignoreRegex, Set<String> ignored, boolean reportNewRootFilesAsNew) throws Exception {
        if (fileOrDir == null || !fileOrDir.exists()) {
            throw new Exception("Non-existent file/directory provided: " + fileOrDir);
        }
        String path = level == 0 ? fileOrDir.getName() : fileOrDir.getAbsolutePath().substring(rootPath.length() + 1);
        path = this.convertPath(path);
        if (ignoreRegex != null) {
            String matchPath = path;
            if (fileOrDir.isDirectory()) {
                matchPath = this.convertPath(path + File.separator);
            }
            if (ignoreRegex.matcher(matchPath).matches()) {
                ignored.add(path);
                return;
            }
        }
        if (fileOrDir.isDirectory()) {
            File[] children;
            if (fileOrDir.getName().equals(".rhqdeployments")) {
                return;
            }
            HashSet<String> relatedTopLevelFiles = null;
            if (level == 0 && !reportNewRootFilesAsNew) {
                relatedTopLevelFiles = new HashSet<String>();
                for (String relatedFilePath : this.keySet()) {
                    File relatedFile = new File(relatedFilePath);
                    if (relatedFile.isAbsolute()) continue;
                    String topLevelName = relatedFile.getName();
                    for (File parent = relatedFile.getParentFile(); parent != null; parent = parent.getParentFile()) {
                        topLevelName = parent.getName();
                    }
                    relatedTopLevelFiles.add(topLevelName);
                }
            }
            if (level > 0 && reportNewRootFilesAsNew && !this.containsKey(path)) {
                newFiles.put(path, DIRECTORY_HASHCODE);
            }
            if ((children = fileOrDir.listFiles()) != null) {
                for (File child : children) {
                    if (relatedTopLevelFiles == null || relatedTopLevelFiles.contains(child.getName())) {
                        this.lookForNewFilesRecursive(newFiles, skippedFiles, rootPath, level + 1, child, ignoreRegex, ignored, reportNewRootFilesAsNew);
                        continue;
                    }
                    skippedFiles.add(child.getName());
                }
            }
        } else if (!this.containsKey(path)) {
            String hashcode;
            try {
                hashcode = MessageDigestGenerator.getDigestString(fileOrDir);
            }
            catch (Exception e) {
                hashcode = UNKNOWN_FILE_HASHCODE;
            }
            newFiles.put(path, hashcode);
        }
    }

    public Map<String, String> getUnknownContent() {
        HashMap unknowns = null;
        for (Map.Entry entry : this.entrySet()) {
            if (!((String)entry.getValue()).equals(UNKNOWN_DIR_HASHCODE) && !((String)entry.getValue()).equals(UNKNOWN_FILE_HASHCODE)) continue;
            if (unknowns == null) {
                unknowns = new HashMap();
            }
            unknowns.put(entry.getKey(), entry.getValue());
        }
        return unknowns;
    }

    @Override
    public String put(String key, String value) {
        return super.put(this.convertPath(key), value);
    }

    @Override
    public String get(Object key) {
        return (String)super.get(this.convertPath((String)key));
    }

    @Override
    public String remove(Object key) {
        return (String)super.remove(this.convertPath((String)key));
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.convertPath((String)key));
    }

    public String convertPath(String path) {
        if (File.separatorChar != '/' && path != null) {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }
}

