/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.rhq.server.metrics.CacheMapper;
import org.rhq.server.metrics.domain.AggregateNumericMetric;

public class AggregateCacheMapper
implements CacheMapper<AggregateNumericMetric> {
    @Override
    public AggregateNumericMetric map(Row row) {
        return new AggregateNumericMetric(this.getScheduleId(row), this.getTimestamp(row), this.getValues(row));
    }

    @Override
    public List<AggregateNumericMetric> map(ResultSet resultSet) {
        ArrayList<AggregateNumericMetric> metrics = new ArrayList<AggregateNumericMetric>();
        for (Row row : resultSet) {
            metrics.add(this.map(row));
        }
        return metrics;
    }

    private int getScheduleId(Row row) {
        return row.getInt(0);
    }

    private long getTimestamp(Row row) {
        return row.getDate(1).getTime();
    }

    private Map<Integer, Double> getValues(Row row) {
        return row.getMap(2, Integer.class, Double.class);
    }
}

