/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.aggregation;

import com.datastax.driver.core.ResultSet;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.rhq.server.metrics.StorageResultSetFuture;
import org.rhq.server.metrics.aggregation.AggregationType;
import org.rhq.server.metrics.aggregation.BaseAggregator;
import org.rhq.server.metrics.aggregation.IndexAggregatesPair;
import org.rhq.server.metrics.aggregation.IndexEntriesLoader;
import org.rhq.server.metrics.domain.CacheIndexEntry;
import org.rhq.server.metrics.domain.RawNumericMetric;
import org.rhq.server.metrics.domain.ResultSetMapper;

class CacheAggregator
extends BaseAggregator {
    private static final Log LOG = LogFactory.getLog(CacheAggregator.class);
    private DateTime currentDay;
    private AtomicInteger schedulesCount = new AtomicInteger();
    private CacheBlockFinishedListener cacheBlockFinishedListener;
    private ResultSetMapper resultSetMapper;

    CacheAggregator() {
    }

    @Override
    void setStartTime(DateTime startTime) {
        this.startTime = startTime;
    }

    void setCurrentDay(DateTime currentDay) {
        this.currentDay = currentDay;
    }

    void setCacheBlockFinishedListener(CacheBlockFinishedListener cacheBlockFinishedListener) {
        this.cacheBlockFinishedListener = cacheBlockFinishedListener;
    }

    void setResultSetMapper(ResultSetMapper resultSetMapper) {
        this.resultSetMapper = resultSetMapper;
    }

    @Override
    protected String getDebugType() {
        return this.aggregationType.toString();
    }

    @Override
    protected List<CacheIndexEntry> getIndexEntries() {
        IndexEntriesLoader loader = new IndexEntriesLoader(this.startTime, this.currentDay, this.dao);
        return loader.loadCurrentCacheIndexEntries(this.indexPageSize, this.aggregationType.getCacheTable());
    }

    @Override
    protected Iterable<CacheIndexEntry> reduceIndexEntries(List<CacheIndexEntry> indexEntries) {
        final PeekingIterator iterator = Iterators.peekingIterator(indexEntries.iterator());
        return new Iterable<CacheIndexEntry>(){

            @Override
            public Iterator<CacheIndexEntry> iterator() {
                return new Iterator<CacheIndexEntry>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext() && ((CacheIndexEntry)iterator.peek()).getCollectionTimeSlice() == ((CacheIndexEntry)iterator.peek()).getInsertTimeSlice();
                    }

                    @Override
                    public CacheIndexEntry next() {
                        return (CacheIndexEntry)iterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    protected BaseAggregator.AggregationTask createAggregationTask(CacheIndexEntry indexEntry) {
        return new BaseAggregator.AggregationTask(indexEntry){

            @Override
            void run(CacheIndexEntry indexEntry) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Executing " + CacheAggregator.this.getDebugType() + " aggregation task for " + indexEntry));
                }
                if (CacheAggregator.this.cacheActive) {
                    StorageResultSetFuture cacheFuture = CacheAggregator.this.dao.findCacheEntriesAsync(CacheAggregator.this.aggregationType.getCacheTable(), CacheAggregator.this.startTime.getMillis(), indexEntry.getStartScheduleId());
                    CacheAggregator.this.processCacheBlock(indexEntry, cacheFuture, (AsyncFunction<IndexAggregatesPair, List<ResultSet>>)CacheAggregator.this.persistMetrics);
                } else {
                    switch (CacheAggregator.this.aggregationType) {
                        case RAW: {
                            CacheAggregator.this.processRawBatches(indexEntry);
                            break;
                        }
                        case ONE_HOUR: {
                            CacheAggregator.this.process1HourBatches(indexEntry);
                            break;
                        }
                        default: {
                            CacheAggregator.this.process6HourBatches(indexEntry);
                        }
                    }
                }
            }
        };
    }

    private void processRawBatches(CacheIndexEntry indexEntry) {
        ArrayList<StorageResultSetFuture> queryFutures = new ArrayList<StorageResultSetFuture>(5);
        long endTime = new DateTime((Object)this.startTime).plusHours(1).getMillis();
        for (Integer scheduleId : indexEntry.getScheduleIds()) {
            queryFutures.add(this.dao.findRawMetricsAsync(scheduleId, indexEntry.getCollectionTimeSlice(), endTime));
            if (queryFutures.size() != 5) continue;
            this.processBatch(queryFutures, indexEntry);
            queryFutures = new ArrayList(5);
        }
        if (!queryFutures.isEmpty()) {
            this.processBatch(queryFutures, indexEntry);
        }
    }

    private void process1HourBatches(CacheIndexEntry indexEntry) {
        ArrayList<StorageResultSetFuture> queryFutures = new ArrayList<StorageResultSetFuture>(5);
        long endTime = this.dateTimeService.get6HourTimeSliceEnd(new DateTime((Object)this.startTime)).getMillis();
        for (Integer scheduleId : indexEntry.getScheduleIds()) {
            queryFutures.add(this.dao.findOneHourMetricsAsync(scheduleId, indexEntry.getCollectionTimeSlice(), endTime));
            if (queryFutures.size() != 5) continue;
            this.processBatch(queryFutures, indexEntry);
            queryFutures = new ArrayList(5);
        }
        if (!queryFutures.isEmpty()) {
            this.processBatch(queryFutures, indexEntry);
        }
    }

    private void process6HourBatches(CacheIndexEntry indexEntry) {
        ArrayList<StorageResultSetFuture> queryFutures = new ArrayList<StorageResultSetFuture>(5);
        long endTime = this.dateTimeService.get24HourTimeSliceEnd(new DateTime((Object)this.startTime)).getMillis();
        for (Integer scheduleId : indexEntry.getScheduleIds()) {
            queryFutures.add(this.dao.findSixHourMetricsAsync(scheduleId, indexEntry.getCollectionTimeSlice(), endTime));
            if (queryFutures.size() != 5) continue;
            this.processBatch(queryFutures, indexEntry);
            queryFutures = new ArrayList(5);
        }
        if (!queryFutures.isEmpty()) {
            this.processBatch(queryFutures, indexEntry);
        }
    }

    @Override
    protected Map<AggregationType, Integer> getAggregationCounts() {
        return ImmutableMap.of((Object)((Object)this.aggregationType), (Object)this.schedulesCount.get());
    }

    protected void processCacheBlock(CacheIndexEntry indexEntry, StorageResultSetFuture cacheFuture, AsyncFunction<IndexAggregatesPair, List<ResultSet>> persistMetricsFn) {
        ListenableFuture iterableFuture = Futures.transform((ListenableFuture)cacheFuture, this.toIterable(this.aggregationType.getCacheMapper()), (Executor)this.aggregationTasks);
        ListenableFuture metricsFuture = Futures.transform((ListenableFuture)iterableFuture, this.computeAggregates(indexEntry.getCollectionTimeSlice(), RawNumericMetric.class), (Executor)this.aggregationTasks);
        ListenableFuture pairFuture = Futures.transform((ListenableFuture)metricsFuture, this.indexAggregatesPair(indexEntry));
        ListenableFuture insertsFuture = Futures.transform((ListenableFuture)pairFuture, persistMetricsFn, (Executor)this.aggregationTasks);
        ListenableFuture deleteCacheFuture = Futures.transform((ListenableFuture)insertsFuture, this.deleteCacheEntry(indexEntry), (Executor)this.aggregationTasks);
        ListenableFuture deleteCacheIndexFuture = Futures.transform((ListenableFuture)deleteCacheFuture, this.deleteCacheIndexEntry(indexEntry), (Executor)this.aggregationTasks);
        this.aggregationTaskFinished((ListenableFuture<ResultSet>)deleteCacheIndexFuture, (ListenableFuture<IndexAggregatesPair>)pairFuture);
    }

    private void processBatch(List<StorageResultSetFuture> queryFutures, CacheIndexEntry indexEntry) {
        ListenableFuture queriesFuture = Futures.allAsList(queryFutures);
        ListenableFuture iterableFuture = Futures.transform((ListenableFuture)queriesFuture, this.toIterable(this.resultSetMapper), (Executor)this.aggregationTasks);
        ListenableFuture metricsFuture = Futures.transform((ListenableFuture)iterableFuture, this.computeAggregates(indexEntry.getCollectionTimeSlice(), RawNumericMetric.class), (Executor)this.aggregationTasks);
        ListenableFuture pairFuture = Futures.transform((ListenableFuture)metricsFuture, this.indexAggregatesPair(indexEntry));
        ListenableFuture insertsFuture = Futures.transform((ListenableFuture)pairFuture, (AsyncFunction)this.persistMetrics, (Executor)this.aggregationTasks);
        ListenableFuture deleteCacheFuture = Futures.transform((ListenableFuture)insertsFuture, this.deleteCacheEntry(indexEntry), (Executor)this.aggregationTasks);
        ListenableFuture deleteCacheIndexFuture = Futures.transform((ListenableFuture)deleteCacheFuture, this.deleteCacheIndexEntry(indexEntry), (Executor)this.aggregationTasks);
        this.aggregationTaskFinished((ListenableFuture<ResultSet>)deleteCacheIndexFuture, (ListenableFuture<IndexAggregatesPair>)pairFuture);
    }

    private void aggregationTaskFinished(ListenableFuture<ResultSet> deleteCacheIndexFuture, ListenableFuture<IndexAggregatesPair> pairFuture) {
        ListenableFuture argsFuture = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{deleteCacheIndexFuture, pairFuture});
        Futures.addCallback((ListenableFuture)argsFuture, (FutureCallback)new BaseAggregator.AggregationTaskFinishedCallback<List<Object>>(){

            @Override
            protected void onFinish(List<Object> args) {
                IndexAggregatesPair pair = (IndexAggregatesPair)args.get(1);
                if (CacheAggregator.this.cacheBlockFinishedListener != null) {
                    CacheAggregator.this.cacheBlockFinishedListener.onFinish(pair);
                }
                CacheAggregator.this.schedulesCount.addAndGet(pair.metrics.size());
            }
        }, (Executor)this.aggregationTasks);
    }

    static interface CacheBlockFinishedListener {
        public void onFinish(IndexAggregatesPair var1);
    }
}

