/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.domain;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.List;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.ColumnMetadata;
import org.rhq.server.metrics.domain.ResultSetMapper;

public class AggregateNumericMetricMapper
implements ResultSetMapper<AggregateNumericMetric> {
    private ResultSetMapper<AggregateNumericMetric> resultSetMapper;

    public AggregateNumericMetricMapper() {
        this(false);
    }

    public AggregateNumericMetricMapper(boolean includeMetadata) {
        this.resultSetMapper = includeMetadata ? new ResultSetMapper<AggregateNumericMetric>(){

            @Override
            public List<AggregateNumericMetric> mapAll(ResultSet resultSet) {
                ArrayList<AggregateNumericMetric> metrics = new ArrayList<AggregateNumericMetric>();
                while (!resultSet.isExhausted()) {
                    metrics.add(this.mapOne(resultSet));
                }
                return metrics;
            }

            @Override
            public AggregateNumericMetric mapOne(ResultSet resultSet) {
                return this.map(resultSet.one(), resultSet.one(), resultSet.one()).get(0);
            }

            @Override
            public List<AggregateNumericMetric> map(Row ... row) {
                ArrayList<AggregateNumericMetric> metrics = new ArrayList<AggregateNumericMetric>();
                for (int i = 0; i < row.length; i += 3) {
                    AggregateNumericMetric metric = new AggregateNumericMetric();
                    metric.setScheduleId(row[i].getInt(0));
                    ColumnMetadata maxMetadata = new ColumnMetadata(row[i].getInt(4), row[i].getLong(5));
                    metric.setMaxColumnMetadata(maxMetadata);
                    metric.setTimestamp(row[i].getDate(1).getTime());
                    metric.setMax(row[i].getDouble(3));
                    if (row[i + 1] != null) {
                        metric.setMin(row[i + 1].getDouble(3));
                        ColumnMetadata minMetadata = new ColumnMetadata(row[i + 1].getInt(4), row[i + 1].getLong(5));
                        metric.setMinColumnMetadata(minMetadata);
                        if (row[i + 2] != null) {
                            metric.setAvg(row[i + 2].getDouble(3));
                            ColumnMetadata avgMetadata = new ColumnMetadata(row[i + 2].getInt(4), row[i + 2].getLong(5));
                            metric.setAvgColumnMetadata(avgMetadata);
                        }
                    }
                    metrics.add(metric);
                }
                return metrics;
            }

            @Override
            public AggregateNumericMetric map(Row row) {
                throw new UnsupportedOperationException("Method is not supported. Only triples are accepted for mapping.");
            }
        } : new ResultSetMapper<AggregateNumericMetric>(){

            @Override
            public List<AggregateNumericMetric> mapAll(ResultSet resultSet) {
                ArrayList<AggregateNumericMetric> metrics = new ArrayList<AggregateNumericMetric>();
                while (!resultSet.isExhausted()) {
                    metrics.add(this.mapOne(resultSet));
                }
                return metrics;
            }

            @Override
            public AggregateNumericMetric mapOne(ResultSet resultSet) {
                return this.map(resultSet.one(), resultSet.one(), resultSet.one()).get(0);
            }

            @Override
            public List<AggregateNumericMetric> map(Row ... row) {
                ArrayList<AggregateNumericMetric> metrics = new ArrayList<AggregateNumericMetric>();
                for (int i = 0; i < row.length; i += 3) {
                    AggregateNumericMetric metric = new AggregateNumericMetric();
                    metric.setScheduleId(row[i].getInt(0));
                    metric.setTimestamp(row[i].getDate(1).getTime());
                    metric.setMax(row[i].getDouble(3));
                    if (row[i + 1] != null) {
                        metric.setMin(row[i + 1].getDouble(3));
                        if (row[i + 2] != null) {
                            metric.setAvg(row[i + 2].getDouble(3));
                        }
                    }
                    metrics.add(metric);
                }
                return metrics;
            }

            @Override
            public AggregateNumericMetric map(Row row) {
                throw new UnsupportedOperationException("Method is not supported. Only triples are accepted for mapping.");
            }
        };
    }

    @Override
    public List<AggregateNumericMetric> mapAll(ResultSet resultSet) {
        return this.resultSetMapper.mapAll(resultSet);
    }

    @Override
    public AggregateNumericMetric mapOne(ResultSet resultSet) {
        return this.resultSetMapper.mapOne(resultSet);
    }

    @Override
    public List<AggregateNumericMetric> map(Row ... rows) {
        return this.resultSetMapper.map(rows);
    }

    @Override
    public AggregateNumericMetric map(Row row) {
        return this.resultSetMapper.map(row);
    }
}

