/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.server.metrics.migrator.ExistingDataBulkExportSource;

public class ExistingPostgresDataBulkExportSource
extends ExistingDataBulkExportSource {
    private final EntityManager entityManager;
    private final String selectNativeQuery;
    private final int maxResults;

    public ExistingPostgresDataBulkExportSource(EntityManager entityManager, String selectNativeQuery) {
        this(entityManager, selectNativeQuery, -1);
    }

    public ExistingPostgresDataBulkExportSource(EntityManager entityManager, String selectNativeQuery, int maxResults) {
        this.entityManager = entityManager;
        this.selectNativeQuery = selectNativeQuery;
        this.maxResults = maxResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportExistingData() throws Exception {
        Connection connection;
        BufferedWriter fileWriter;
        block3: {
            fileWriter = null;
            connection = null;
            try {
                fileWriter = new BufferedWriter(new FileWriter(this.getExistingDataFile()), 65536);
                Session session = (Session)this.entityManager.getDelegate();
                SessionFactoryImplementor sfi = (SessionFactoryImplementor)session.getSessionFactory();
                ConnectionProvider cp = sfi.getConnectionProvider();
                connection = cp.getConnection();
                CopyManager copyManager = new CopyManager((BaseConnection)connection);
                if (this.maxResults > 0) {
                    copyManager.copyOut("COPY (" + this.selectNativeQuery + " LIMIT " + this.maxResults + ") TO STDOUT WITH DELIMITER '" + "|" + "'", (Writer)fileWriter);
                    break block3;
                }
                copyManager.copyOut("COPY (" + this.selectNativeQuery + ") TO STDOUT WITH DELIMITER '" + "|" + "'", (Writer)fileWriter);
            }
            catch (Throwable throwable) {
                StreamUtil.safeClose(fileWriter);
                JDBCUtil.safeClose(connection);
                throw throwable;
            }
        }
        StreamUtil.safeClose((Closeable)fileWriter);
        JDBCUtil.safeClose((Connection)connection);
    }
}

