/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.migrator.workers;

import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.StatelessSession;
import org.rhq.server.metrics.domain.MetricsTable;
import org.rhq.server.metrics.migrator.DataMigrator;
import org.rhq.server.metrics.migrator.ExistingDataSource;
import org.rhq.server.metrics.migrator.Telemetry;
import org.rhq.server.metrics.migrator.workers.AbstractMigrationWorker;
import org.rhq.server.metrics.migrator.workers.CallableMigrationWorker;
import org.rhq.server.metrics.migrator.workers.MetricsIndexUpdateAccumulator;
import org.rhq.server.metrics.migrator.workers.MigrationQuery;

public class RawDataMigrator
extends AbstractMigrationWorker
implements CallableMigrationWorker {
    private final Log log = LogFactory.getLog(RawDataMigrator.class);
    private final Queue<String> tablesNotProcessed = new LinkedList<String>(Arrays.asList(RawDataMigrator.getRawDataTables()));
    private final MetricsIndexUpdateAccumulator metricsIndexAccumulator;
    private final DataMigrator.DataMigratorConfiguration config;

    public RawDataMigrator(DataMigrator.DataMigratorConfiguration config) {
        this.config = config;
        this.metricsIndexAccumulator = new MetricsIndexUpdateAccumulator(MetricsTable.RAW, config);
    }

    @Override
    public long estimate() throws Exception {
        long recordCount = 0L;
        for (String table : RawDataMigrator.getRawDataTables()) {
            String countQuery = String.format(MigrationQuery.COUNT_RAW.toString(), table);
            long tableRecordCount = this.getRowCount(countQuery);
            this.log.debug((Object)("Retrieved record count for table " + table + " -- " + tableRecordCount));
            recordCount += tableRecordCount;
        }
        Telemetry telemetry = this.performMigration(DataMigrator.Task.Estimate);
        long estimatedTimeToMigrate = telemetry.getMigrationTime();
        long estimation = recordCount / 30000L / 4L * estimatedTimeToMigrate;
        return estimation += telemetry.getNonMigrationTime();
    }

    @Override
    public void migrate() throws Exception {
        this.performMigration(DataMigrator.Task.Migrate);
    }

    private long getRowCount(String countQuery) {
        StatelessSession session = this.getSQLSession(this.config);
        SQLQuery query = session.createSQLQuery(countQuery);
        query.setReadOnly(true);
        query.setTimeout(6000000);
        long count = Long.parseLong(query.uniqueResult().toString());
        this.closeSQLSession(session);
        return count;
    }

    private Telemetry performMigration(DataMigrator.Task task) throws Exception {
        Telemetry telemetry = new Telemetry();
        telemetry.getGeneralTimer().start();
        long numberOfBatchesMigrated = 0L;
        telemetry.getMigrationTimer().start();
        telemetry.getMigrationTimer().suspend();
        while (!this.tablesNotProcessed.isEmpty()) {
            List<Object[]> existingData;
            String table = this.tablesNotProcessed.peek();
            String selectQuery = String.format(MigrationQuery.SELECT_RAW_DATA.toString(), table);
            ExistingDataSource dataSource = this.getExistingDataSource(selectQuery, task, this.config);
            dataSource.initialize();
            this.log.info((Object)("Start migrating raw table: " + table));
            telemetry.getMigrationTimer().resume();
            int lastMigratedRecord = 0;
            while ((existingData = dataSource.getData(lastMigratedRecord, 30000)).size() != 0) {
                lastMigratedRecord += existingData.size();
                int failureCount = 0;
                while (failureCount < 5) {
                    try {
                        this.insertDataToCassandra(existingData);
                        break;
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to insert " + MetricsTable.RAW.toString() + " data. Attempting to insert the current batch of data one more time"));
                        this.log.error((Object)e);
                        if (++failureCount != 50) continue;
                        throw e;
                    }
                }
                this.log.info((Object)("- " + table + " - " + lastMigratedRecord + " -"));
                if (!DataMigrator.Task.Estimate.equals((Object)task) || ++numberOfBatchesMigrated < 4L) continue;
            }
            telemetry.getMigrationTimer().suspend();
            if (DataMigrator.Task.Migrate.equals((Object)task)) {
                this.log.info((Object)("Done migrating raw table" + table + "---------------------"));
                if (this.config.isDeleteDataImmediatelyAfterMigration()) {
                    this.deleteTableData(table);
                }
            } else if (numberOfBatchesMigrated >= 4L) break;
            dataSource.close();
            this.tablesNotProcessed.poll();
        }
        telemetry.getMigrationTimer().resume();
        this.metricsIndexAccumulator.drain();
        telemetry.getMigrationTimer().suspend();
        telemetry.getGeneralTimer().stop();
        return telemetry;
    }

    private void deleteTableData(String table) throws Exception {
        String deleteQuery = String.format(MigrationQuery.DELETE_RAW_ENTRY.toString(), table);
        int failureCount = 0;
        while (failureCount < 5) {
            try {
                StatelessSession session = this.getSQLSession(this.config);
                session.getTransaction().begin();
                SQLQuery nativeQuery = session.createSQLQuery(deleteQuery);
                nativeQuery.executeUpdate();
                session.getTransaction().commit();
                this.closeSQLSession(session);
                this.log.info((Object)("- " + table + " - Cleaned -"));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to delete " + table + " data. Attempting to delete data one more time..."));
                if (++failureCount != 5) continue;
                throw e;
            }
        }
    }

    private void insertDataToCassandra(List<Object[]> existingData) throws Exception {
        ArrayList<ResultSetFuture> resultSetFutures = new ArrayList<ResultSetFuture>();
        Batch batch = QueryBuilder.batch((Statement[])new Statement[0]);
        int batchSize = 0;
        long currentTimeMillis = System.currentTimeMillis();
        long expectedTTLMillis = MetricsTable.RAW.getTTLinMilliseconds();
        for (Object[] rawDataPoint : existingData) {
            long creationTimeMillis = Long.parseLong(rawDataPoint[1].toString());
            long itemTTLSeconds = (expectedTTLMillis - currentTimeMillis + creationTimeMillis) / 1000L;
            if (itemTTLSeconds > 0L) {
                int scheduleId = Integer.parseInt(rawDataPoint[0].toString());
                Date creationTime = new Date(creationTimeMillis);
                batch.add((Statement)QueryBuilder.insertInto((String)MetricsTable.RAW.toString()).value("schedule_id", (Object)scheduleId).value("time", (Object)creationTime).value("value", (Object)Double.parseDouble(rawDataPoint[2].toString())).using(QueryBuilder.ttl((int)((int)itemTTLSeconds))));
                ++batchSize;
                this.metricsIndexAccumulator.add(scheduleId, creationTimeMillis);
            }
            if (batchSize < 100) continue;
            resultSetFutures.add(this.config.getSession().executeAsync((Query)batch));
            batch = QueryBuilder.batch((Statement[])new Statement[0]);
            batchSize = 0;
        }
        if (batchSize != 0) {
            resultSetFutures.add(this.config.getSession().executeAsync((Query)batch));
        }
        for (ResultSetFuture future : resultSetFutures) {
            future.get();
        }
    }
}

