/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class ShutdownPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.shutdown", new Object[0]);
    }

    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        if (args.length > 1) {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return true;
        }
        if (agent.isStarted()) {
            out.println(MSG.getMsg("PromptCommand.shutdown.shutting-down", new Object[0]));
            agent.shutdown();
            out.println(MSG.getMsg("PromptCommand.shutdown.done", new Object[0]));
        } else {
            out.println(MSG.getMsg("PromptCommand.shutdown.already-shutdown", new Object[0]));
        }
        return true;
    }

    public String getSyntax() {
        return this.getPromptCommandString();
    }

    public String getHelp() {
        return MSG.getMsg("PromptCommand.shutdown.help", new Object[0]);
    }

    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.shutdown.detailed-help", new Object[0]);
    }
}

