/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Conversation;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.clientapi.RemoteClient;
import org.rhq.enterprise.server.auth.SubjectManagerRemote;

@Name(value="PerspectiveClientUIBean")
@Scope(value=ScopeType.CONVERSATION)
@AutoCreate
public class PerspectiveClientUIBean {
    public static final String NAME = "PerspectiveClientUIBean";
    private static final String DEFAULT_SERVER_HOST = "127.0.0.1";
    private static final int DEFAULT_SERVER_PORT = 7080;
    private static final String DEFAULT_USERNAME = "rhqadmin";
    private static final String DEFAULT_PASSWORD = "rhqadmin";
    private final Log log = LogFactory.getLog(this.getClass());
    @RequestParameter
    private String rhqServerHost;
    private String serverHost;
    @RequestParameter
    private Integer rhqServerPort;
    private Integer serverPort;
    @RequestParameter
    private String rhqUsername;
    private String username;
    @RequestParameter
    private String rhqPassword;
    private String password;
    @RequestParameter
    private Integer rhqSessionId;
    private RemoteClient remoteClient;
    private Subject subject;
    private String coreGuiBaseUrl;

    @NotNull
    public RemoteClient getRemoteClient() throws Exception {
        if (this.remoteClient == null) {
            this.remoteClient = new RemoteClient(null, this.getServerHost(), this.getServerPort());
        }
        if (!this.remoteClient.isConnected()) {
            try {
                this.remoteClient.connect();
            }
            catch (Exception e) {
                this.remoteClient = null;
                this.log.info((Object)("Ending perspective client Conversation with id " + Conversation.instance().getId() + "..."));
                Conversation.instance().end();
                throw e;
            }
            Conversation.instance().begin();
            this.log.info((Object)("Began perspective client Conversation with id " + Conversation.instance().getId() + "."));
        }
        return this.remoteClient;
    }

    @NotNull
    public Subject getSubject() throws Exception {
        if (this.subject == null) {
            RemoteClient remoteClient = this.getRemoteClient();
            SubjectManagerRemote subjectManager = remoteClient.getSubjectManager();
            if (this.rhqSessionId != null) {
                this.log.info((Object)("Retrieving subject for user [" + this.getUsername() + "] and sessionId [" + this.rhqSessionId + "]..."));
                this.subject = subjectManager.getSubjectByNameAndSessionId(this.getUsername(), this.rhqSessionId.intValue());
            } else {
                this.log.info((Object)("Logging in as user [" + this.getUsername() + "] with password [" + this.getPassword() + "]..."));
                this.subject = subjectManager.login(this.getUsername(), this.getPassword());
            }
        }
        return this.subject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private String getServerHost() {
        if (this.serverHost == null) {
            if (this.rhqServerHost == null) return DEFAULT_SERVER_HOST;
            this.serverHost = this.rhqServerHost;
            return this.serverHost;
        } else if (this.rhqServerHost != null && !this.serverHost.equals(this.rhqServerHost)) return this.serverHost;
        return this.serverHost;
    }

    private int getServerPort() {
        if (this.serverPort == null) {
            if (this.rhqServerPort != null) {
                this.serverPort = this.rhqServerPort;
            } else {
                return 7080;
            }
        }
        return this.serverPort;
    }

    @NotNull
    private String getUsername() {
        if (this.username == null) {
            if (this.rhqUsername != null) {
                this.username = this.rhqUsername;
            } else {
                return "rhqadmin";
            }
        }
        return this.username;
    }

    @NotNull
    private String getPassword() {
        if (this.password == null) {
            if (this.rhqPassword != null) {
                this.password = this.rhqPassword;
            } else {
                return "rhqadmin";
            }
        }
        return this.password;
    }
}

