/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.JBossASServerShutdownMethod;
import org.rhq.plugins.jbossas.JBossASServerSupportedOperations;

public class JBossASServerOperationsDelegate {
    private static long STOP_WAIT_MAX = 150000L;
    private static final long STOP_WAIT_INTERVAL = 10000L;
    private static final long STOP_WAIT_FINAL = 30000L;
    private static long START_WAIT_MAX = 300000L;
    private static final long START_WAIT_INTERVAL = 10000L;
    private final Log log = LogFactory.getLog(JBossASServerOperationsDelegate.class);
    private static final String SEPARATOR = "\n-----------------------\n";
    private JBossASServerComponent serverComponent;
    private SystemInfo systemInfo;

    public JBossASServerOperationsDelegate(JBossASServerComponent serverComponent, SystemInfo systemInfo) {
        this.serverComponent = serverComponent;
        this.systemInfo = systemInfo;
    }

    public OperationResult invoke(JBossASServerSupportedOperations operation, Configuration parameters) throws InterruptedException {
        String message = null;
        switch (operation) {
            case RESTART: {
                message = this.restart();
                break;
            }
            case SHUTDOWN: {
                message = this.shutdown();
                break;
            }
            case START: {
                message = this.start();
            }
        }
        OperationResult result = new OperationResult(message);
        return result;
    }

    private String start() throws InterruptedException {
        AvailabilityType avail;
        ProcessExecution processExecution;
        Configuration pluginConfiguration = this.serverComponent.getPluginConfiguration();
        File startScriptFile = this.serverComponent.getStartScriptPath();
        this.validateScriptFile(startScriptFile, "startScript");
        String prefix = pluginConfiguration.getSimple("scriptPrefix").getStringValue();
        String configName = this.serverComponent.getConfigurationSet();
        String bindingAddress = pluginConfiguration.getSimple("bindingAddress").getStringValue();
        String configArgument = "-c" + configName;
        String bindingAddressArgument = null;
        if (bindingAddress != null) {
            bindingAddressArgument = "-b" + bindingAddress;
        }
        if (prefix == null || prefix.replaceAll("\\s", "").equals("")) {
            processExecution = ProcessExecutionUtility.createProcessExecution((File)startScriptFile);
            processExecution.getArguments().add("-c");
            processExecution.getArguments().add(configName);
            if (bindingAddressArgument != null) {
                processExecution.getArguments().add("-b");
                processExecution.getArguments().add(bindingAddress);
            }
        } else {
            StringTokenizer prefixTokenizer = new StringTokenizer(prefix);
            String processName = prefixTokenizer.nextToken();
            File prefixProcess = new File(processName);
            processExecution = ProcessExecutionUtility.createProcessExecution((File)prefixProcess);
            while (prefixTokenizer.hasMoreTokens()) {
                String prefixArgument = prefixTokenizer.nextToken();
                processExecution.getArguments().add(prefixArgument);
            }
            String startScriptArgument = startScriptFile.getAbsolutePath();
            startScriptArgument = startScriptArgument + " " + configArgument;
            if (bindingAddressArgument != null) {
                startScriptArgument = startScriptArgument + " " + bindingAddressArgument;
            }
            processExecution.getArguments().add(startScriptArgument);
        }
        this.initProcessExecution(processExecution, startScriptFile);
        long start = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        ProcessExecutionResults results = this.systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() == null) {
            avail = this.waitForServerToStart(start);
        } else {
            this.log.error((Object)("Error from process execution while starting the AS instance. Exit code [" + results.getExitCode() + "]"), results.getError());
            avail = this.serverComponent.getAvailability();
        }
        if (avail == AvailabilityType.DOWN) {
            throw new RuntimeException("Server failed to start: " + results.getCapturedOutput());
        }
        return "Server has been started.";
    }

    private void initProcessExecution(ProcessExecution processExecution, File scriptFile) {
        processExecution.setWorkingDirectory(scriptFile.getParent());
        File javaHomeDir = this.serverComponent.getJavaHomePath();
        if (javaHomeDir == null) {
            throw new IllegalStateException("The 'javaHomePath' connection property must be set in order to start or stop JBossAS via script.");
        }
        this.serverComponent.validateJavaHomePathProperty();
        processExecution.getEnvironmentVariables().put("JAVA_HOME", javaHomeDir.getPath());
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(1000L);
        processExecution.setKillOnTimeout(false);
    }

    private String shutdown() {
        JBossASServerShutdownMethod shutdownMethod = Enum.valueOf(JBossASServerShutdownMethod.class, this.serverComponent.getPluginConfiguration().getSimple("shutdownMethod").getStringValue());
        String result = JBossASServerShutdownMethod.JMX.equals((Object)shutdownMethod) ? this.shutdownViaJmx() : this.shutdownViaScript();
        AvailabilityType avail = this.waitForServerToShutdown();
        if (avail == AvailabilityType.UP) {
            throw new RuntimeException("Server failed to shutdown");
        }
        return result;
    }

    private String shutdownViaScript() {
        String password;
        String user;
        Configuration pluginConfiguration = this.serverComponent.getPluginConfiguration();
        File shutdownScriptFile = this.serverComponent.getShutdownScriptPath();
        this.validateScriptFile(shutdownScriptFile, "shutdownScript");
        String prefix = pluginConfiguration.getSimple("scriptPrefix").getStringValue();
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((String)prefix, (File)shutdownScriptFile);
        this.initProcessExecution(processExecution, shutdownScriptFile);
        String server = pluginConfiguration.getSimple("namingURL").getStringValue();
        if (server != null) {
            processExecution.getArguments().add("--server=" + server);
        }
        if ((user = pluginConfiguration.getSimple("principal").getStringValue()) != null) {
            processExecution.getArguments().add("--user=" + user);
        }
        if ((password = pluginConfiguration.getSimple("credentials").getStringValue()) != null) {
            processExecution.getArguments().add("--password=" + password);
        }
        processExecution.getArguments().add("--shutdown");
        processExecution.getEnvironmentVariables().put("NOPAUSE", "1");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        ProcessExecutionResults results = this.systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() != null) {
            throw new RuntimeException("Error executing shutdown script while stopping AS instance. Exit code [" + results.getExitCode() + "]", results.getError());
        }
        return "Server has been shut down.";
    }

    private void logExecutionResults(ProcessExecutionResults results) {
        this.log.info((Object)("Exit code from process execution: " + results.getExitCode()));
        this.log.info((Object)("Output from process execution: \n-----------------------\n" + results.getCapturedOutput() + SEPARATOR));
    }

    private String shutdownViaJmx() {
        Configuration pluginConfiguration = this.serverComponent.getPluginConfiguration();
        String mbeanName = pluginConfiguration.getSimple("shutdownMbeanName").getStringValue();
        String operationName = pluginConfiguration.getSimple("shutdownMbeanOperation").getStringValue();
        EmsConnection connection = this.serverComponent.getEmsConnection();
        if (connection == null) {
            throw new RuntimeException("Can not connect to the server");
        }
        EmsBean bean = connection.getBean(mbeanName);
        EmsOperation operation = bean.getOperation(operationName);
        List params = operation.getParameters();
        int count = params.size();
        if (count == 0) {
            operation.invoke(new Object[0]);
        } else {
            operation.invoke(new Object[]{0});
        }
        return "Server has been shut down.";
    }

    private void validateScriptFile(File scriptFile, String scriptPropertyName) {
        if (!scriptFile.exists()) {
            throw new RuntimeException("Script (" + scriptFile + ") specified via '" + scriptPropertyName + "' connection property does not exist.");
        }
        if (scriptFile.isDirectory()) {
            throw new RuntimeException("Script (" + scriptFile + ") specified via '" + scriptPropertyName + "' connection property is a directory, not a file.");
        }
    }

    private String restart() {
        try {
            this.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException("Shutdown may have failed: " + e);
        }
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Re-Startup may have failed: " + e);
        }
        return "Server has been restarted.";
    }

    private AvailabilityType waitForServerToStart(long start) throws InterruptedException {
        AvailabilityType avail;
        int newValue;
        Configuration pluginConfig = this.serverComponent.getPluginConfiguration();
        PropertySimple property = pluginConfig.getSimple("startWaitMax");
        if (property != null && property.getIntegerValue() != null && (newValue = property.getIntegerValue().intValue()) >= 1) {
            START_WAIT_MAX = 60000L * (long)newValue;
        }
        while ((avail = this.serverComponent.getAvailability()) == AvailabilityType.DOWN && System.currentTimeMillis() < start + START_WAIT_MAX) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {}
        }
        return avail;
    }

    private AvailabilityType waitForServerToShutdown() {
        int newValue;
        Configuration pluginConfig = this.serverComponent.getPluginConfiguration();
        PropertySimple property = pluginConfig.getSimple("stopWaitMax");
        if (property != null && property.getIntegerValue() != null && (newValue = property.getIntegerValue().intValue()) >= 1) {
            STOP_WAIT_MAX = 60000L * (long)newValue;
        }
        for (long wait = 0L; wait < STOP_WAIT_MAX && AvailabilityType.UP == this.serverComponent.getAvailability(); wait += 10000L) {
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverComponent.getAvailability();
    }
}

