/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.script;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.jbossas.JBossASServerComponent;

public class ScriptComponent
implements ResourceComponent<JBossASServerComponent<?>>,
OperationFacet {
    public static final String PATH_CONFIG_PROP = "path";
    public static final String ENVIRONMENT_VARIABLES_CONFIG_PROP = "environmentVariables";
    public static final String EXECUTE_OPERATION = "execute";
    public static final String COMMAND_LINE_ARGUMENTS_PARAM_PROP = "commandLineArguments";
    private static final String EXIT_CODE_RESULT_PROP = "exitCode";
    private static final String OUTPUT_RESULT_PROP = "output";
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<JBossASServerComponent<?>> resourceContext;

    public void start(ResourceContext<JBossASServerComponent<?>> resourceContext) {
        this.resourceContext = resourceContext;
    }

    public void stop() {
        this.resourceContext = null;
    }

    public AvailabilityType getAvailability() {
        File scriptFile = this.getScriptFile();
        return scriptFile.exists() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        if (name.equals(EXECUTE_OPERATION)) {
            ProcessExecutionResults processExecutionResults;
            OperationResult operationResult = new OperationResult();
            File scriptFile = this.getScriptFile();
            SystemInfo systemInfo = this.resourceContext.getSystemInformation();
            ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((File)scriptFile);
            processExecution.setWaitForCompletion(3600000L);
            processExecution.setCaptureOutput(true);
            processExecution.setWorkingDirectory(scriptFile.getParent());
            this.setEnvironmentVariables(processExecution);
            this.setCommandLineArguments(params, processExecution);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)processExecution);
            }
            if ((processExecutionResults = systemInfo.executeProcess(processExecution)).getError() != null) {
                throw new Exception(processExecutionResults.getError());
            }
            Integer exitCode = processExecutionResults.getExitCode();
            String output = processExecutionResults.getCapturedOutput();
            Configuration complexResults = operationResult.getComplexResults();
            complexResults.put((Property)new PropertySimple(EXIT_CODE_RESULT_PROP, (Object)exitCode));
            complexResults.put((Property)new PropertySimple(OUTPUT_RESULT_PROP, (Object)output));
            if (exitCode != null && exitCode != 0) {
                operationResult.setErrorMessage("Exit code was '" + exitCode + "', see operation results for details");
            }
            return operationResult;
        }
        throw new IllegalArgumentException("Unsupported operation: " + name);
    }

    private void setCommandLineArguments(Configuration params, ProcessExecution processExecution) {
        ArrayList<String> processExecutionArguments = processExecution.getArguments();
        if (null == processExecutionArguments) {
            processExecutionArguments = new ArrayList<String>();
            processExecution.setArguments(processExecutionArguments);
        }
        String cmdLineArgsString = params.getSimpleValue(COMMAND_LINE_ARGUMENTS_PARAM_PROP, null);
        List<String> cmdLineArgs = this.createCommandLineArgumentList(cmdLineArgsString);
        processExecutionArguments.addAll(cmdLineArgs);
    }

    private void setEnvironmentVariables(ProcessExecution processExecution) {
        String envVars;
        Map<String, String> envVarsMap;
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        LinkedHashMap<String, String> processExecutionEnvironmentVariables = processExecution.getEnvironmentVariables();
        if (null == processExecutionEnvironmentVariables) {
            processExecutionEnvironmentVariables = new LinkedHashMap<String, String>();
            processExecution.setEnvironmentVariables(processExecutionEnvironmentVariables);
        }
        if (null != (envVarsMap = this.createEnvironmentVariableMap(envVars = pluginConfig.getSimpleValue(ENVIRONMENT_VARIABLES_CONFIG_PROP, null)))) {
            processExecutionEnvironmentVariables.putAll(envVarsMap);
        }
    }

    @NotNull
    private List<String> createCommandLineArgumentList(String cmdLineArgsString) {
        if (cmdLineArgsString == null) {
            return new ArrayList<String>();
        }
        StringTokenizer tokenizer = new StringTokenizer(cmdLineArgsString, "\n");
        ArrayList<String> cmdLineArgs = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String cmdLineArg = tokenizer.nextToken().trim();
            cmdLineArg = this.replacePropertyPatterns(cmdLineArg);
            cmdLineArgs.add(cmdLineArg);
        }
        return cmdLineArgs;
    }

    private Map<String, String> createEnvironmentVariableMap(String envVarsString) {
        if (envVarsString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(envVarsString, "\n");
        LinkedHashMap<String, String> envVars = new LinkedHashMap<String, String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            String var = tokenizer.nextToken().trim();
            int equalsIndex = var.indexOf(61);
            if (equalsIndex == -1) {
                throw new IllegalStateException("Malformed environment entry: " + var);
            }
            String varName = var.substring(0, equalsIndex);
            String varValue = var.substring(equalsIndex + 1);
            varValue = this.replacePropertyPatterns(varValue);
            envVars.put(varName, varValue);
        }
        return envVars;
    }

    private String replacePropertyPatterns(String value) {
        Pattern pattern = Pattern.compile("(%([^%]*)%)");
        Matcher matcher = pattern.matcher(value);
        Configuration parentPluginConfig = ((JBossASServerComponent)this.resourceContext.getParentResourceComponent()).getPluginConfiguration();
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String propName = matcher.group(2);
            PropertySimple prop = parentPluginConfig.getSimple(propName);
            String propValue = prop != null && prop.getStringValue() != null ? prop.getStringValue() : "";
            String propPattern = matcher.group(1);
            String replacement = prop != null ? propValue : propPattern;
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private File getScriptFile() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String scriptFilePath = pluginConfig.getSimple(PATH_CONFIG_PROP).getStringValue();
        return new File(scriptFilePath);
    }
}

