/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.plugins.jbossas.ApplicationComponent;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.util.DeploymentUtility;
import org.rhq.plugins.jbossas.util.WarDeploymentInformation;
import org.rhq.plugins.jmx.util.ObjectNameQueryUtility;
import org.xml.sax.InputSource;

public class WarDiscoveryHelper {
    private static final Log LOG = LogFactory.getLog(WarDiscoveryHelper.class);
    private static final String ROOT_WEBAPP_RT_LOG_FILE_NAME_BASE = "ROOT";
    private static final String RT_LOG_FILE_NAME_SUFFIX = "_rt.log";
    private static final String WEB_SERVICES_EJB_WAR_FILE_NAME_REGEX = "\\.(ejb|jar)\\d+\\.war$";
    private static final Pattern WEB_SERVICES_EJB_WAR_FILE_NAME_PATTERN = Pattern.compile("\\.(ejb|jar)\\d+\\.war$");
    private static final String ROOT_WEBAPP_RESOURCE_NAME = "ROOT.war";

    private WarDiscoveryHelper() {
    }

    public static Set<DiscoveredResourceDetails> initPluginConfigurations(JBossASServerComponent<?> parentJBossASComponent, Set<DiscoveredResourceDetails> warResources, ApplicationComponent parentEARComponent) {
        EmsConnection jmxConnection = parentJBossASComponent.getEmsConnection();
        File configPath = parentJBossASComponent.getConfigurationPath();
        File logDir = new File(configPath, "log");
        File rtLogDir = new File(logDir, "rt");
        ArrayList<String> objectNames = new ArrayList<String>();
        for (DiscoveredResourceDetails resourceDetails : warResources) {
            Configuration warConfig = resourceDetails.getPluginConfiguration();
            PropertySimple objectNameProperty = warConfig.getSimple("objectName");
            objectNames.add(objectNameProperty.getStringValue());
        }
        Map<String, List<WarDeploymentInformation>> deploymentInformations = DeploymentUtility.getWarDeploymentInformation(jmxConnection, objectNames);
        HashSet<DiscoveredResourceDetails> resultingResources = new HashSet<DiscoveredResourceDetails>();
        Iterator<DiscoveredResourceDetails> warResourcesIterator = warResources.iterator();
        while (warResourcesIterator.hasNext()) {
            DiscoveredResourceDetails discoResDetail = warResourcesIterator.next();
            Configuration warConfig = discoResDetail.getPluginConfiguration();
            PropertySimple objectNameProperty = warConfig.getSimple("objectName");
            List<WarDeploymentInformation> deploymentInfoList = null;
            if (deploymentInformations != null) {
                deploymentInfoList = deploymentInformations.get(objectNameProperty.getStringValue());
            }
            if (deploymentInfoList != null) {
                String baseResourceName = discoResDetail.getResourceName();
                String baseResourceDescription = discoResDetail.getResourceDescription();
                for (WarDeploymentInformation info : deploymentInfoList) {
                    String contextPath = WarDiscoveryHelper.getContextPath(info.getContextRoot());
                    String webModuleName = "//" + info.getVHost() + contextPath;
                    discoResDetail.setResourceName(baseResourceName + " (" + webModuleName + ")");
                    discoResDetail.setResourceDescription(baseResourceDescription + " (" + webModuleName + ")");
                    String vhost = info.getVHost();
                    if ("localhost".equals(vhost)) {
                        WarDiscoveryHelper.initPluginConfiguration(info, rtLogDir, warResourcesIterator, discoResDetail);
                        resultingResources.add(discoResDetail);
                        continue;
                    }
                    String key = discoResDetail.getResourceKey();
                    key = key + ",vhost=" + vhost;
                    Configuration pluginConfigClone = discoResDetail.getPluginConfiguration().deepCopy();
                    String resourceName = baseResourceName + " (" + webModuleName + ")";
                    String resourceDescription = baseResourceDescription + " (" + webModuleName + ")";
                    DiscoveredResourceDetails myDetail = new DiscoveredResourceDetails(discoResDetail.getResourceType(), key, resourceName, discoResDetail.getResourceVersion(), resourceDescription, pluginConfigClone, discoResDetail.getProcessInfo());
                    WarDiscoveryHelper.initPluginConfiguration(info, rtLogDir, warResourcesIterator, myDetail);
                    resultingResources.add(myDetail);
                }
                continue;
            }
            if (parentEARComponent == null) {
                warResourcesIterator.remove();
                if (discoResDetail.getResourceName().equals(ROOT_WEBAPP_RESOURCE_NAME)) continue;
                LOG.debug((Object)("The deployed WAR '" + discoResDetail.getResourceName() + "' does not have a jboss.web MBean (i.e. context root) associated with it; it will not be added to inventory."));
                continue;
            }
            String appName = parentEARComponent.getApplicationName();
            String warName = objectNameProperty.getStringValue();
            Pattern pat = Pattern.compile(".*,name=([\\w-]+\\.war).*");
            Matcher m = pat.matcher(warName);
            if (m.find()) {
                warName = m.group(1);
            }
            String contextRoot = WarDiscoveryHelper.getContextRootFromEar(parentEARComponent, parentJBossASComponent, warName);
            warConfig.put((Property)new PropertySimple("contextRoot", (Object)contextRoot));
            String webName = WarDiscoveryHelper.getJbossWebNameFromContextRoot(contextRoot, parentJBossASComponent);
            warConfig.put((Property)new PropertySimple("jbossWebName", (Object)webName));
            warConfig.put((Property)new PropertySimple("vHost", (Object)"localhost"));
            WarDiscoveryHelper.setRtLogInPluginConfig(rtLogDir, warConfig, contextRoot, "localhost");
            resultingResources.add(discoResDetail);
        }
        return resultingResources;
    }

    private static String getContextRootFromEar(ApplicationComponent parentEARComponent, JBossASServerComponent<?> parentJBossASComponent, String warName) {
        String contextRoot = " - invalid - ";
        String objectNameTemplate = "jboss.management.local:J2EEServer=Local,j2eeType=J2EEApplication,name=" + parentEARComponent.getApplicationName();
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(objectNameTemplate);
        List mBeans = parentJBossASComponent.getEmsConnection().queryBeans(queryUtility.getTranslatedQuery());
        if (mBeans.size() == 1) {
            EmsBean theBean = (EmsBean)mBeans.get(0);
            EmsAttribute ddAttr = theBean.getAttribute("deploymentDescriptor");
            ddAttr.refresh();
            ddAttr.getValue();
            String dd = (String)ddAttr.getValue();
            InputSource is = new InputSource(new StringReader(dd));
            XPath xp = XPathFactory.newInstance().newXPath();
            try {
                contextRoot = xp.evaluate("/application/module/web/web-uri['" + warName + "']/../context-root", is);
            }
            catch (XPathException xpe) {
                xpe.printStackTrace();
            }
        }
        return contextRoot;
    }

    private static String getJbossWebNameFromContextRoot(String contextRoot, JBossASServerComponent<?> parentJBossASComponent) {
        if (contextRoot.startsWith("/")) {
            contextRoot = contextRoot.substring(1);
        }
        String objectNameTemplate = "jboss.web:j2eeType=WebModule,name=//localhost/" + contextRoot + ",J2EEApplication=none,J2EEServer=none";
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(objectNameTemplate);
        List mBeans = parentJBossASComponent.getEmsConnection().queryBeans(queryUtility.getTranslatedQuery());
        if (mBeans.size() == 1) {
            EmsBean theMBean = (EmsBean)mBeans.get(0);
            return theMBean.getBeanName().getCanonicalName();
        }
        return null;
    }

    public static void setDeploymentInformation(Configuration pluginConfig, WarDeploymentInformation deploymentInformation) {
        pluginConfig.put((Property)new PropertySimple("filename", (Object)deploymentInformation.getFileName()));
        pluginConfig.put((Property)new PropertySimple("jbossWebName", (Object)deploymentInformation.getJbossWebModuleMBeanObjectName()));
        pluginConfig.put((Property)new PropertySimple("contextRoot", (Object)deploymentInformation.getContextRoot()));
        pluginConfig.put((Property)new PropertySimple("vHost", (Object)deploymentInformation.getVHost()));
    }

    public static String getContextPath(String contextRoot) {
        return contextRoot == null || contextRoot.equals("/") ? "/" : "/" + contextRoot;
    }

    private static void initPluginConfiguration(WarDeploymentInformation deploymentInformation, File rtLogDir, Iterator<DiscoveredResourceDetails> warResourcesIterator, DiscoveredResourceDetails resource) {
        Configuration pluginConfig = resource.getPluginConfiguration();
        String warFileName = resource.getResourceName();
        String contextRoot = deploymentInformation.getContextRoot();
        int length = contextRoot.length();
        if (length > 0 && contextRoot.charAt(length - 1) == '.' && WEB_SERVICES_EJB_WAR_FILE_NAME_PATTERN.matcher(warFileName).find()) {
            warResourcesIterator.remove();
            return;
        }
        WarDiscoveryHelper.setDeploymentInformation(pluginConfig, deploymentInformation);
        String vHost = deploymentInformation.getVHost();
        WarDiscoveryHelper.setRtLogInPluginConfig(rtLogDir, pluginConfig, contextRoot, vHost);
    }

    private static void setRtLogInPluginConfig(File rtLogDir, Configuration pluginConfig, String contextRoot, String vHost) {
        if (!contextRoot.equals("/")) {
            contextRoot = contextRoot.replace('/', '_');
        }
        String rtLogFileNameBase = contextRoot.equals("/") ? ROOT_WEBAPP_RT_LOG_FILE_NAME_BASE : contextRoot;
        vHost = "localhost".equals(vHost) ? "" : vHost + "_";
        String rtLogFileName = vHost + rtLogFileNameBase + RT_LOG_FILE_NAME_SUFFIX;
        File rtLogFile = new File(rtLogDir, rtLogFileName);
        pluginConfig.put((Property)new PropertySimple("responseTimeLogFile", (Object)rtLogFile));
    }
}

