/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.rhq.augeas.AugeasComponent;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.apache.ApacheVirtualHostServiceComponent;
import org.rhq.plugins.apache.util.AugeasNodeSearch;

public class ApacheIfModuleDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheVirtualHostServiceComponent> {
    private static final String[] parentRes = new String[]{"<IfModule"};
    private static final String IFMODULE_NODE_NAME = "<IfModule";
    private AugeasTree tree;
    private AugeasNode parentNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheVirtualHostServiceComponent> context) throws InvalidPluginConfigurationException, Exception {
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        ApacheVirtualHostServiceComponent virtualHost = (ApacheVirtualHostServiceComponent)context.getParentResourceComponent();
        if (!virtualHost.isAugeasEnabled()) {
            return discoveredResources;
        }
        AugeasComponent comp = virtualHost.getAugeas();
        AugeasTree tree = null;
        try {
            tree = comp.getAugeasTree("Httpd");
            this.parentNode = virtualHost.getNode(tree);
            List<AugeasNode> ifModuleNodes = AugeasNodeSearch.searchNode(parentRes, IFMODULE_NODE_NAME, this.parentNode);
            ResourceType resourceType = context.getResourceType();
            for (AugeasNode node : ifModuleNodes) {
                String resourceKey = AugeasNodeSearch.getNodeKey(node, this.parentNode);
                String[] paramArray = resourceKey.split("\\|");
                String resourceName = paramArray[1];
                discoveredResources.add(new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, null, null, null, null));
            }
            LinkedHashSet<DiscoveredResourceDetails> linkedHashSet = discoveredResources;
            return linkedHashSet;
        }
        finally {
            comp.close();
        }
    }
}

